/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.spdy.CompressionFactory;
import org.eclipse.jetty.spdy.frames.ControlFrameType;
import org.eclipse.jetty.spdy.frames.SynReplyFrame;
import org.eclipse.jetty.spdy.parser.ControlFrameBodyParser;
import org.eclipse.jetty.spdy.parser.ControlFrameParser;
import org.eclipse.jetty.spdy.parser.HeadersBlockParser;
import org.eclipse.jetty.util.Fields;

public class SynReplyBodyParser
extends ControlFrameBodyParser {
    private final Fields headers = new Fields();
    private final ControlFrameParser controlFrameParser;
    private final HeadersBlockParser headersBlockParser;
    private State state = State.STREAM_ID;
    private int cursor;
    private int streamId;

    public SynReplyBodyParser(CompressionFactory.Decompressor decompressor, ControlFrameParser controlFrameParser) {
        this.controlFrameParser = controlFrameParser;
        this.headersBlockParser = new SynReplyHeadersBlockParser(decompressor);
    }

    @Override
    public boolean parse(ByteBuffer buffer) {
        block11: while (buffer.hasRemaining()) {
            switch (this.state) {
                case STREAM_ID: {
                    if (buffer.remaining() >= 4) {
                        this.streamId = buffer.getInt() & Integer.MAX_VALUE;
                        this.state = State.ADDITIONAL;
                        continue block11;
                    }
                    this.state = State.STREAM_ID_BYTES;
                    this.cursor = 4;
                    continue block11;
                }
                case STREAM_ID_BYTES: {
                    byte currByte = buffer.get();
                    --this.cursor;
                    this.streamId += (currByte & 0xFF) << 8 * this.cursor;
                    if (this.cursor != 0) continue block11;
                    this.streamId &= Integer.MAX_VALUE;
                    this.state = State.ADDITIONAL;
                    continue block11;
                }
                case ADDITIONAL: {
                    switch (this.controlFrameParser.getVersion()) {
                        case 2: {
                            if (buffer.remaining() >= 2) {
                                buffer.getShort();
                                this.state = State.HEADERS;
                                continue block11;
                            }
                            this.state = State.ADDITIONAL_BYTES;
                            this.cursor = 2;
                            continue block11;
                        }
                        case 3: {
                            this.state = State.HEADERS;
                            continue block11;
                        }
                    }
                    throw new IllegalStateException();
                }
                case ADDITIONAL_BYTES: {
                    assert (this.controlFrameParser.getVersion() == 2);
                    buffer.get();
                    --this.cursor;
                    if (this.cursor != 0) continue block11;
                    this.state = State.HEADERS;
                    continue block11;
                }
                case HEADERS: {
                    int length;
                    short version = this.controlFrameParser.getVersion();
                    if (!this.headersBlockParser.parse(this.streamId, version, length = this.controlFrameParser.getLength() - this.getSynReplyDataLength(version), buffer)) continue block11;
                    byte flags = this.controlFrameParser.getFlags();
                    if (flags != 0 && flags != 1) {
                        throw new IllegalArgumentException("Invalid flag " + flags + " for frame " + (Object)((Object)ControlFrameType.SYN_REPLY));
                    }
                    SynReplyFrame frame = new SynReplyFrame(version, flags, this.streamId, new Fields(this.headers, true));
                    this.controlFrameParser.onControlFrame(frame);
                    this.reset();
                    return true;
                }
            }
            throw new IllegalStateException();
        }
        return false;
    }

    private int getSynReplyDataLength(short version) {
        switch (version) {
            case 2: {
                return 6;
            }
            case 3: {
                return 4;
            }
        }
        throw new IllegalStateException();
    }

    private void reset() {
        this.headers.clear();
        this.state = State.STREAM_ID;
        this.cursor = 0;
        this.streamId = 0;
    }

    private static enum State {
        STREAM_ID,
        STREAM_ID_BYTES,
        ADDITIONAL,
        ADDITIONAL_BYTES,
        HEADERS;

    }

    private class SynReplyHeadersBlockParser
    extends HeadersBlockParser {
        public SynReplyHeadersBlockParser(CompressionFactory.Decompressor decompressor) {
            super(decompressor);
        }

        @Override
        protected void onHeader(String name, String[] values) {
            for (String value : values) {
                SynReplyBodyParser.this.headers.add(name, value);
            }
        }
    }
}

