/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server.http;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.spdy.api.ByteBufferDataInfo;
import org.eclipse.jetty.spdy.api.DataInfo;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.http.HTTPSPDYHeader;
import org.eclipse.jetty.spdy.server.http.HttpInputOverSPDY;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpChannelOverSPDY
extends HttpChannel<DataInfo> {
    private static final Logger LOG = Log.getLogger(HttpChannelOverSPDY.class);
    private final Stream stream;
    private boolean dispatched;
    private boolean redispatch;
    private boolean headersComplete;

    public HttpChannelOverSPDY(Connector connector, HttpConfiguration configuration, EndPoint endPoint, HttpTransport transport, HttpInputOverSPDY input, Stream stream) {
        super(connector, configuration, endPoint, transport, (HttpInput)input);
        this.stream = stream;
    }

    public long getIdleTimeout() {
        return this.stream.getIdleTimeout();
    }

    public boolean headerComplete() {
        this.headersComplete = true;
        return super.headerComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch() {
        HttpChannelOverSPDY httpChannelOverSPDY = this;
        synchronized (httpChannelOverSPDY) {
            if (this.dispatched) {
                this.redispatch = true;
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Dispatch {}", new Object[]{this});
                }
                this.dispatched = true;
                this.execute((Runnable)((Object)this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean execute = true;
        while (execute) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Executing {}", new Object[]{this});
                }
                super.run();
            }
            catch (Throwable throwable) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Completing {}", new Object[]{this});
                }
                HttpChannelOverSPDY httpChannelOverSPDY = this;
                synchronized (httpChannelOverSPDY) {
                    this.dispatched = this.redispatch;
                    this.redispatch = false;
                    execute = this.dispatched;
                }
                throw throwable;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Completing {}", new Object[]{this});
            }
            HttpChannelOverSPDY httpChannelOverSPDY = this;
            synchronized (httpChannelOverSPDY) {
                this.dispatched = this.redispatch;
                this.redispatch = false;
                execute = this.dispatched;
            }
        }
    }

    public void requestStart(Fields headers, boolean endRequest) {
        if (!headers.isEmpty()) {
            this.requestHeaders(headers, endRequest);
        }
    }

    public void requestHeaders(Fields headers, boolean endRequest) {
        boolean proceed = this.performBeginRequest(headers);
        if (!proceed) {
            return;
        }
        this.performHeaders(headers);
        if (endRequest) {
            boolean dispatch = this.headerComplete();
            if (this.messageComplete()) {
                dispatch = true;
            }
            if (dispatch) {
                this.dispatch();
            }
        }
    }

    public void requestContent(final DataInfo dataInfo, boolean endRequest) {
        boolean dispatch = false;
        if (!this.headersComplete && this.headerComplete()) {
            dispatch = true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP > {} bytes of content", (long)dataInfo.length());
        }
        ByteBuffer copyByteBuffer = dataInfo.asByteBuffer(false);
        ByteBufferDataInfo copyDataInfo = new ByteBufferDataInfo(copyByteBuffer, dataInfo.isClose()){

            public void consume(int delta) {
                super.consume(delta);
                dataInfo.consume(delta);
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("Queuing last={} content {}", new Object[]{endRequest, copyDataInfo});
        }
        if (this.content(copyDataInfo)) {
            dispatch = true;
        }
        if (endRequest && this.messageComplete()) {
            dispatch = true;
        }
        if (dispatch) {
            this.dispatch();
        }
    }

    public boolean messageComplete() {
        super.messageComplete();
        return false;
    }

    private boolean performBeginRequest(Fields headers) {
        short version = this.stream.getSession().getVersion();
        Fields.Field methodHeader = headers.get(HTTPSPDYHeader.METHOD.name(version));
        Fields.Field uriHeader = headers.get(HTTPSPDYHeader.URI.name(version));
        Fields.Field versionHeader = headers.get(HTTPSPDYHeader.VERSION.name(version));
        if (methodHeader == null || uriHeader == null || versionHeader == null) {
            this.badMessage(400, "Missing required request line elements");
            return false;
        }
        HttpMethod httpMethod = HttpMethod.fromString((String)methodHeader.getValue());
        HttpVersion httpVersion = HttpVersion.fromString((String)versionHeader.getValue());
        ByteBuffer uri = BufferUtil.toBuffer((String)uriHeader.getValue());
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP > {} {} {}", new Object[]{httpMethod, uriHeader.getValue(), httpVersion});
        }
        this.startRequest(httpMethod, httpMethod.asString(), uri, httpVersion);
        Fields.Field schemeHeader = headers.get(HTTPSPDYHeader.SCHEME.name(version));
        if (schemeHeader != null) {
            this.getRequest().setScheme(schemeHeader.getValue());
        }
        return true;
    }

    private void performHeaders(Fields headers) {
        block9: for (Fields.Field header : headers) {
            String name = header.getName();
            HTTPSPDYHeader specialHeader = HTTPSPDYHeader.from((short)this.stream.getSession().getVersion(), (String)name);
            if (specialHeader != null) {
                if (specialHeader != HTTPSPDYHeader.HOST) continue;
                name = "host";
            }
            switch (name) {
                case "connection": 
                case "keep-alive": 
                case "proxy-connection": 
                case "transfer-encoding": {
                    continue block9;
                }
            }
            String value = header.getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP > {}: {}", new Object[]{name, value});
            }
            this.parsedHeader(new HttpField(name, value));
        }
    }
}

