/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.io;

import java.io.EOFException;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.UpgradeException;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.ClientUpgradeResponse;
import org.eclipse.jetty.websocket.client.io.ConnectPromise;
import org.eclipse.jetty.websocket.client.io.UpgradeListener;
import org.eclipse.jetty.websocket.client.io.WebSocketClientConnection;
import org.eclipse.jetty.websocket.common.AcceptHash;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.SessionFactory;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.extensions.ExtensionStack;
import org.eclipse.jetty.websocket.common.io.http.HttpResponseHeaderParseListener;
import org.eclipse.jetty.websocket.common.io.http.HttpResponseHeaderParser;

public class UpgradeConnection
extends AbstractConnection
implements Connection.UpgradeFrom {
    private static final int SWITCHING_PROTOCOLS = 101;
    private static final Logger LOG = Log.getLogger(UpgradeConnection.class);
    private final ByteBufferPool bufferPool;
    private final ConnectPromise connectPromise;
    private final HttpResponseHeaderParser parser;
    private State state = State.REQUEST;
    private ClientUpgradeRequest request;
    private ClientUpgradeResponse response;

    public UpgradeConnection(EndPoint endp, Executor executor, ConnectPromise connectPromise) {
        super(endp, executor);
        this.connectPromise = connectPromise;
        this.bufferPool = connectPromise.getClient().getBufferPool();
        this.request = connectPromise.getRequest();
        this.parser = new HttpResponseHeaderParser((HttpResponseHeaderParseListener)new ClientUpgradeResponse());
    }

    public void disconnect(boolean onlyOutput) {
        EndPoint endPoint = this.getEndPoint();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Shutting down output {}", new Object[]{endPoint});
        }
        endPoint.shutdownOutput();
        if (!onlyOutput) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing {}", new Object[]{endPoint});
            }
            endPoint.close();
        }
    }

    private void failUpgrade(Throwable cause) {
        this.close();
        this.connectPromise.failed(cause);
    }

    private void notifyConnect(ClientUpgradeResponse response) {
        this.connectPromise.setResponse(response);
        UpgradeListener handshakeListener = this.connectPromise.getUpgradeListener();
        if (handshakeListener != null) {
            handshakeListener.onHandshakeResponse(response);
        }
    }

    public ByteBuffer onUpgradeFrom() {
        return this.connectPromise.getResponse().getRemainingBuffer();
    }

    public void onFillable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onFillable", new Object[0]);
        }
        ByteBuffer buffer = this.bufferPool.acquire(this.getInputBufferSize(), false);
        BufferUtil.clear((ByteBuffer)buffer);
        try {
            this.read(buffer);
        }
        finally {
            this.bufferPool.release(buffer);
        }
        if (this.state == State.RESPONSE) {
            this.fillInterested();
        } else if (this.state == State.UPGRADE) {
            this.upgradeConnection(this.response);
        }
    }

    public void onOpen() {
        super.onOpen();
        this.getExecutor().execute(new SendUpgradeRequest());
    }

    public void onClose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closed connection {}", new Object[]{this});
        }
        super.onClose();
    }

    protected boolean onReadTimeout() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Timeout on connection {}", new Object[]{this});
        }
        this.failUpgrade(new IOException("Timeout while performing WebSocket Upgrade"));
        return super.onReadTimeout();
    }

    private void read(ByteBuffer buffer) {
        EndPoint endPoint = this.getEndPoint();
        try {
            do {
                int filled;
                if ((filled = endPoint.fill(buffer)) == 0) {
                    return;
                }
                if (filled < 0) {
                    LOG.warn("read - EOF Reached", new Object[0]);
                    this.state = State.FAILURE;
                    this.failUpgrade(new EOFException("Reading WebSocket Upgrade response"));
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Filled {} bytes - {}", new Object[]{filled, BufferUtil.toDetailString((ByteBuffer)buffer)});
                }
                this.response = (ClientUpgradeResponse)this.parser.parse(buffer);
            } while (this.response == null);
            this.validateResponse(this.response);
            this.notifyConnect(this.response);
            this.state = State.UPGRADE;
            return;
        }
        catch (IOException | HttpResponseHeaderParser.ParseException e) {
            LOG.ignore(e);
            this.state = State.FAILURE;
            UpgradeException ue = new UpgradeException(this.request.getRequestURI(), e);
            this.connectPromise.failed(ue);
            this.disconnect(false);
        }
        catch (UpgradeException e) {
            LOG.ignore((Throwable)e);
            this.state = State.FAILURE;
            this.connectPromise.failed(e);
            this.disconnect(false);
        }
    }

    private void upgradeConnection(ClientUpgradeResponse response) {
        EndPoint endp = this.getEndPoint();
        Executor executor = this.getExecutor();
        EventDriver websocket = this.connectPromise.getDriver();
        WebSocketPolicy policy = websocket.getPolicy();
        WebSocketClientConnection connection = new WebSocketClientConnection(endp, executor, this.connectPromise, policy);
        SessionFactory sessionFactory = this.connectPromise.getClient().getSessionFactory();
        WebSocketSession session = sessionFactory.createSession(this.request.getRequestURI(), websocket, (LogicalConnection)connection);
        session.setPolicy(policy);
        session.setUpgradeRequest((UpgradeRequest)this.request);
        session.setUpgradeResponse((UpgradeResponse)response);
        connection.addListener((Connection.Listener)session);
        this.connectPromise.setSession(session);
        ExtensionStack extensionStack = new ExtensionStack(this.connectPromise.getClient().getExtensionFactory());
        extensionStack.negotiate(response.getExtensions());
        extensionStack.configure(connection.getParser());
        extensionStack.configure(connection.getGenerator());
        connection.setNextIncomingFrames((IncomingFrames)extensionStack);
        extensionStack.setNextIncoming((IncomingFrames)session);
        session.setOutgoingHandler((OutgoingFrames)extensionStack);
        extensionStack.setNextOutgoing((OutgoingFrames)connection);
        session.addManaged((LifeCycle)extensionStack);
        this.connectPromise.getClient().addManaged((LifeCycle)session);
        endp.upgrade((Connection)connection);
    }

    private void validateResponse(ClientUpgradeResponse response) {
        if (response.getStatusCode() != 101) {
            throw new UpgradeException(this.request.getRequestURI(), response.getStatusCode(), "Didn't switch protocols, expected status <101>, but got <" + response.getStatusCode() + ">");
        }
        String connection = response.getHeader("Connection");
        if (!"upgrade".equalsIgnoreCase(connection)) {
            throw new UpgradeException(this.request.getRequestURI(), response.getStatusCode(), "Connection is " + connection + " (expected upgrade)");
        }
        String reqKey = this.request.getKey();
        String expectedHash = AcceptHash.hashKey((String)reqKey);
        String respHash = response.getHeader("Sec-WebSocket-Accept");
        response.setSuccess(true);
        if (!expectedHash.equalsIgnoreCase(respHash)) {
            response.setSuccess(false);
            throw new UpgradeException(this.request.getRequestURI(), response.getStatusCode(), "Invalid Sec-WebSocket-Accept hash");
        }
        ArrayList<ExtensionConfig> extensions = new ArrayList<ExtensionConfig>();
        List extValues = response.getHeaders("Sec-WebSocket-Extensions");
        if (extValues != null) {
            for (String extVal : extValues) {
                QuotedStringTokenizer tok = new QuotedStringTokenizer(extVal, ",");
                while (tok.hasMoreTokens()) {
                    extensions.add(ExtensionConfig.parse((String)tok.nextToken()));
                }
            }
        }
        response.setExtensions(extensions);
    }

    public class SendUpgradeRequest
    extends FutureCallback
    implements Runnable {
        private final Logger LOG = Log.getLogger(SendUpgradeRequest.class);

        @Override
        public void run() {
            URI uri = UpgradeConnection.this.connectPromise.getRequest().getRequestURI();
            UpgradeConnection.this.request.setRequestURI(uri);
            UpgradeListener handshakeListener = UpgradeConnection.this.connectPromise.getUpgradeListener();
            if (handshakeListener != null) {
                handshakeListener.onHandshakeRequest(UpgradeConnection.this.request);
            }
            String rawRequest = UpgradeConnection.this.request.generate();
            ByteBuffer buf = BufferUtil.toBuffer((String)rawRequest, (Charset)StandardCharsets.UTF_8);
            UpgradeConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{buf});
        }

        public void succeeded() {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Upgrade Request Write Success", new Object[0]);
            }
            super.succeeded();
            UpgradeConnection.this.state = State.RESPONSE;
            UpgradeConnection.this.fillInterested();
        }

        public void failed(Throwable cause) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Upgrade Request Write Failure", cause);
            }
            super.failed(cause);
            UpgradeConnection.this.state = State.FAILURE;
            UpgradeConnection.this.connectPromise.failed(cause);
        }
    }

    private static enum State {
        REQUEST,
        RESPONSE,
        FAILURE,
        UPGRADE;

    }
}

