/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ThreadClassLoaderScope;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.CloseException;
import org.eclipse.jetty.websocket.api.CloseStatus;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.SuspendToken;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.ConnectionState;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.RemoteEndpointFactory;
import org.eclipse.jetty.websocket.common.WebSocketRemoteEndpoint;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.frames.CloseFrame;
import org.eclipse.jetty.websocket.common.io.IOState;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import org.eclipse.jetty.websocket.common.scopes.WebSocketSessionScope;

@ManagedObject(value="A Jetty WebSocket Session")
public class WebSocketSession
extends ContainerLifeCycle
implements Session,
RemoteEndpointFactory,
WebSocketSessionScope,
IncomingFrames,
Connection.Listener,
IOState.ConnectionStateListener {
    private static final Logger LOG = Log.getLogger(WebSocketSession.class);
    private static final Logger LOG_OPEN = Log.getLogger((String)(WebSocketSession.class.getName() + "_OPEN"));
    private final WebSocketContainerScope containerScope;
    private final URI requestURI;
    private final LogicalConnection connection;
    private final EventDriver websocket;
    private final Executor executor;
    private final WebSocketPolicy policy;
    private final AtomicBoolean closed = new AtomicBoolean();
    private ClassLoader classLoader;
    private ExtensionFactory extensionFactory;
    private RemoteEndpointFactory remoteEndpointFactory;
    private String protocolVersion;
    private Map<String, String[]> parameterMap = new HashMap<String, String[]>();
    private RemoteEndpoint remote;
    private IncomingFrames incomingHandler;
    private OutgoingFrames outgoingHandler;
    private UpgradeRequest upgradeRequest;
    private UpgradeResponse upgradeResponse;
    private CompletableFuture<Session> openFuture;

    public WebSocketSession(WebSocketContainerScope containerScope, URI requestURI, EventDriver websocket, LogicalConnection connection) {
        Objects.requireNonNull(containerScope, "Container Scope cannot be null");
        Objects.requireNonNull(requestURI, "Request URI cannot be null");
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.containerScope = containerScope;
        this.requestURI = requestURI;
        this.websocket = websocket;
        this.connection = connection;
        this.executor = connection.getExecutor();
        this.outgoingHandler = connection;
        this.incomingHandler = websocket;
        this.connection.getIOState().addListener(this);
        this.policy = websocket.getPolicy();
        this.connection.setSession(this);
        this.addBean(this.connection);
        this.addBean(this.websocket);
    }

    public void abort(int statusCode, String reason) {
        this.close(new CloseInfo(statusCode, reason), new DisconnectCallback());
    }

    public void close() {
        this.close(new CloseInfo(1000), null);
    }

    public void close(CloseStatus closeStatus) {
        this.close(new CloseInfo(closeStatus.getCode(), closeStatus.getPhrase()), null);
    }

    public void close(int statusCode, String reason) {
        this.close(new CloseInfo(statusCode, reason), null);
    }

    private void close(CloseInfo closeInfo, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("close({})", new Object[]{closeInfo});
        }
        if (this.closed.compareAndSet(false, true)) {
            CloseFrame frame = closeInfo.asFrame();
            this.connection.outgoingFrame(frame, new OnCloseLocalCallback(callback, this.connection, closeInfo), BatchMode.OFF);
        }
    }

    public void disconnect() {
        this.connection.disconnect();
        this.notifyClose(1006, "Harsh disconnect");
    }

    public void dispatch(Runnable runnable) {
        this.executor.execute(runnable);
    }

    protected void doStart() throws Exception {
        Iterator<RemoteEndpointFactory> iter;
        if (LOG.isDebugEnabled()) {
            LOG.debug("starting - {}", new Object[]{this});
        }
        if ((iter = ServiceLoader.load(RemoteEndpointFactory.class).iterator()).hasNext()) {
            this.remoteEndpointFactory = iter.next();
        }
        if (this.remoteEndpointFactory == null) {
            this.remoteEndpointFactory = this;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using RemoteEndpointFactory: {}", new Object[]{this.remoteEndpointFactory});
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("stopping - {}", new Object[]{this});
        }
        try {
            this.close(1001, "Shutdown");
        }
        catch (Throwable t) {
            LOG.debug("During Connection Shutdown", t);
        }
        super.doStop();
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, new Object[]{DumpableCollection.from((String)"incoming", (Object[])new Object[]{this.incomingHandler}), DumpableCollection.from((String)"outgoing", (Object[])new Object[]{this.outgoingHandler})});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebSocketSession other = (WebSocketSession)obj;
        return !(this.connection == null ? other.connection != null : !this.connection.equals(other.connection));
    }

    public ByteBufferPool getBufferPool() {
        return this.connection.getBufferPool();
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public LogicalConnection getConnection() {
        return this.connection;
    }

    @Override
    public WebSocketContainerScope getContainerScope() {
        return this.containerScope;
    }

    public ExtensionFactory getExtensionFactory() {
        return this.extensionFactory;
    }

    public long getIdleTimeout() {
        return this.connection.getMaxIdleTimeout();
    }

    @ManagedAttribute(readonly=true)
    public IncomingFrames getIncomingHandler() {
        return this.incomingHandler;
    }

    public InetSocketAddress getLocalAddress() {
        return this.connection.getLocalAddress();
    }

    @ManagedAttribute(readonly=true)
    public OutgoingFrames getOutgoingHandler() {
        return this.outgoingHandler;
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public RemoteEndpoint getRemote() {
        ConnectionState state;
        if (LOG_OPEN.isDebugEnabled()) {
            LOG_OPEN.debug("[{}] {}.getRemote()", new Object[]{this.policy.getBehavior(), this.getClass().getSimpleName()});
        }
        if ((state = this.connection.getIOState().getConnectionState()) == ConnectionState.OPEN || state == ConnectionState.CONNECTED) {
            return this.remote;
        }
        throw new WebSocketException("RemoteEndpoint unavailable, current state [" + (Object)((Object)state) + "], expecting [OPEN or CONNECTED]");
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remote.getInetSocketAddress();
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    public UpgradeRequest getUpgradeRequest() {
        return this.upgradeRequest;
    }

    public UpgradeResponse getUpgradeResponse() {
        return this.upgradeResponse;
    }

    @Override
    public WebSocketSession getWebSocketSession() {
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.connection == null ? 0 : this.connection.hashCode());
        return result;
    }

    public void incomingError(Throwable t) {
        this.websocket.incomingError(t);
    }

    public void incomingFrame(Frame frame) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            if (this.connection.getIOState().isInputAvailable()) {
                this.incomingHandler.incomingFrame(frame);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public boolean isOpen() {
        if (this.connection == null) {
            return false;
        }
        return !this.closed.get() && this.connection.isOpen();
    }

    public boolean isSecure() {
        if (this.upgradeRequest == null) {
            throw new IllegalStateException("No valid UpgradeRequest yet");
        }
        URI requestURI = this.upgradeRequest.getRequestURI();
        return "wss".equalsIgnoreCase(requestURI.getScheme());
    }

    public void notifyClose(int statusCode, String reason) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("notifyClose({},{})", new Object[]{statusCode, reason});
        }
        this.websocket.onClose(new CloseInfo(statusCode, reason));
    }

    public void notifyError(Throwable cause) {
        if (this.openFuture != null && !this.openFuture.isDone()) {
            this.openFuture.completeExceptionally(cause);
        }
        this.incomingError(cause);
    }

    public void onClosed(Connection connection) {
    }

    public void onOpened(Connection connection) {
        if (LOG_OPEN.isDebugEnabled()) {
            LOG_OPEN.debug("[{}] {}.onOpened()", new Object[]{this.policy.getBehavior(), this.getClass().getSimpleName()});
        }
        this.open();
    }

    @Override
    public void onConnectionStateChange(ConnectionState state) {
        switch (state) {
            case CLOSED: {
                IOState ioState = this.connection.getIOState();
                CloseInfo close = ioState.getCloseInfo();
                this.notifyClose(close.getStatusCode(), close.getReason());
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{}.onSessionClosed()", new Object[]{this.containerScope.getClass().getSimpleName()});
                    }
                    this.containerScope.onSessionClosed(this);
                }
                catch (Throwable t) {
                    LOG.ignore(t);
                }
                break;
            }
            case CONNECTED: {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{}.onSessionOpened()", new Object[]{this.containerScope.getClass().getSimpleName()});
                    }
                    this.containerScope.onSessionOpened(this);
                    break;
                }
                catch (Throwable t) {
                    LOG.ignore(t);
                }
            }
        }
    }

    @Override
    public WebSocketRemoteEndpoint newRemoteEndpoint(LogicalConnection connection, OutgoingFrames outgoingFrames, BatchMode batchMode) {
        return new WebSocketRemoteEndpoint(connection, this.outgoingHandler, this.getBatchMode());
    }

    public void open() {
        if (LOG_OPEN.isDebugEnabled()) {
            LOG_OPEN.debug("[{}] {}.open()", new Object[]{this.policy.getBehavior(), this.getClass().getSimpleName()});
        }
        if (this.remote != null) {
            return;
        }
        try (ThreadClassLoaderScope scope = new ThreadClassLoaderScope(this.classLoader);){
            this.connection.getIOState().onConnected();
            this.remote = this.remoteEndpointFactory.newRemoteEndpoint(this.connection, this.outgoingHandler, this.getBatchMode());
            if (LOG_OPEN.isDebugEnabled()) {
                LOG_OPEN.debug("[{}] {}.open() remote={}", new Object[]{this.policy.getBehavior(), this.getClass().getSimpleName(), this.remote});
            }
            this.websocket.openSession(this);
            this.connection.getIOState().onOpened();
            if (LOG.isDebugEnabled()) {
                LOG.debug("[{}] open -> {}", new Object[]{this.getPolicy().getBehavior(), this.dump()});
            }
            if (this.openFuture != null) {
                this.openFuture.complete(this);
            }
        }
        catch (CloseException ce) {
            LOG.warn((Throwable)ce);
            this.close(ce.getStatusCode(), ce.getMessage());
        }
        catch (Throwable t) {
            LOG.warn(t);
            int statusCode = 1011;
            if (this.policy.getBehavior() == WebSocketBehavior.CLIENT) {
                statusCode = 1008;
            }
            this.close(statusCode, t.getMessage());
        }
    }

    public void setExtensionFactory(ExtensionFactory extensionFactory) {
        this.extensionFactory = extensionFactory;
    }

    public void setFuture(CompletableFuture<Session> fut) {
        this.openFuture = fut;
    }

    public void setIdleTimeout(long ms) {
        this.connection.setMaxIdleTimeout(ms);
    }

    public void setOutgoingHandler(OutgoingFrames outgoing) {
        this.outgoingHandler = outgoing;
    }

    @Deprecated
    public void setPolicy(WebSocketPolicy policy) {
    }

    public void setUpgradeRequest(UpgradeRequest request) {
        this.upgradeRequest = request;
        this.protocolVersion = request.getProtocolVersion();
        this.parameterMap.clear();
        if (request.getParameterMap() != null) {
            for (Map.Entry entry : request.getParameterMap().entrySet()) {
                List values = (List)entry.getValue();
                if (values != null) {
                    this.parameterMap.put((String)entry.getKey(), values.toArray(new String[values.size()]));
                    continue;
                }
                this.parameterMap.put((String)entry.getKey(), new String[0]);
            }
        }
    }

    public void setUpgradeResponse(UpgradeResponse response) {
        this.upgradeResponse = response;
    }

    public SuspendToken suspend() {
        return this.connection.suspend();
    }

    public BatchMode getBatchMode() {
        return BatchMode.AUTO;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WebSocketSession[");
        builder.append("websocket=").append(this.websocket);
        builder.append(",behavior=").append(this.policy.getBehavior());
        builder.append(",connection=").append(this.connection);
        builder.append(",remote=").append(this.remote);
        builder.append(",incoming=").append(this.incomingHandler);
        builder.append(",outgoing=").append(this.outgoingHandler);
        builder.append("]");
        return builder.toString();
    }

    public class DisconnectCallback
    implements Callback {
        public void failed(Throwable x) {
            WebSocketSession.this.disconnect();
        }

        public void succeeded() {
            WebSocketSession.this.disconnect();
        }
    }

    public static interface Listener {
        public void onOpened(WebSocketSession var1);

        public void onClosed(WebSocketSession var1);
    }

    public static class OnCloseLocalCallback
    implements WriteCallback {
        private final Callback callback;
        private final LogicalConnection connection;
        private final CloseInfo close;

        public OnCloseLocalCallback(Callback callback, LogicalConnection connection, CloseInfo close) {
            this.callback = callback;
            this.connection = connection;
            this.close = close;
        }

        public void writeSuccess() {
            try {
                if (this.callback != null) {
                    this.callback.succeeded();
                }
            }
            finally {
                this.connection.onLocalClose(this.close);
            }
        }

        public void writeFailed(Throwable x) {
            try {
                if (this.callback != null) {
                    this.callback.failed(x);
                }
            }
            finally {
                this.connection.onLocalClose(this.close);
            }
        }
    }
}

