/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356;

import java.net.HttpCookie;
import java.util.List;
import java.util.Map;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.HandshakeResponse;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.client.io.UpgradeListener;
import org.eclipse.jetty.websocket.jsr356.JsrHandshakeResponse;

public class JsrUpgradeListener
implements UpgradeListener {
    private ClientEndpointConfig.Configurator configurator;

    public JsrUpgradeListener(ClientEndpointConfig.Configurator configurator) {
        this.configurator = configurator;
    }

    public void onHandshakeRequest(UpgradeRequest request) {
        if (this.configurator == null) {
            return;
        }
        Map headers = request.getHeaders();
        this.configurator.beforeRequest(headers);
        for (String name : headers.keySet()) {
            List values;
            if (!"cookie".equalsIgnoreCase(name) || (values = (List)headers.get(name)) == null) continue;
            for (String cookie : values) {
                List<HttpCookie> cookies = HttpCookie.parse(cookie);
                request.getCookies().addAll(cookies);
            }
        }
    }

    public void onHandshakeResponse(UpgradeResponse response) {
        if (this.configurator == null) {
            return;
        }
        JsrHandshakeResponse hr = new JsrHandshakeResponse(response);
        this.configurator.afterResponse((HandshakeResponse)hr);
    }
}

