/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.websocket.api.InvalidWebSocketException;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.api.util.QuoteUtil;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.SessionFactory;
import org.eclipse.jetty.websocket.common.SessionListener;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.WebSocketSessionFactory;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.events.EventDriverFactory;
import org.eclipse.jetty.websocket.common.extensions.ExtensionStack;
import org.eclipse.jetty.websocket.common.extensions.WebSocketExtensionFactory;
import org.eclipse.jetty.websocket.server.HandshakeRFC6455;
import org.eclipse.jetty.websocket.server.WebSocketHandshake;
import org.eclipse.jetty.websocket.server.WebSocketServerConnection;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public class WebSocketServerFactory
extends ContainerLifeCycle
implements WebSocketCreator,
WebSocketServletFactory,
SessionListener {
    private static final Logger LOG = Log.getLogger(WebSocketServerFactory.class);
    private final ClassLoader contextClassloader;
    private final Map<Integer, WebSocketHandshake> handshakes = new HashMap<Integer, WebSocketHandshake>();
    private final Scheduler scheduler = new ScheduledExecutorScheduler();
    private final String supportedVersions;
    private final WebSocketPolicy defaultPolicy;
    private final EventDriverFactory eventDriverFactory;
    private final ByteBufferPool bufferPool;
    private final WebSocketExtensionFactory extensionFactory;
    private List<SessionFactory> sessionFactories;
    private Set<WebSocketSession> openSessions = new CopyOnWriteArraySet<WebSocketSession>();
    private WebSocketCreator creator;
    private List<Class<?>> registeredSocketClasses;

    public WebSocketServerFactory() {
        this(WebSocketPolicy.newServerPolicy(), (ByteBufferPool)new MappedByteBufferPool());
    }

    public WebSocketServerFactory(WebSocketPolicy policy) {
        this(policy, (ByteBufferPool)new MappedByteBufferPool());
    }

    public WebSocketServerFactory(ByteBufferPool bufferPool) {
        this(WebSocketPolicy.newServerPolicy(), bufferPool);
    }

    public WebSocketServerFactory(WebSocketPolicy policy, ByteBufferPool bufferPool) {
        this.handshakes.put(13, new HandshakeRFC6455());
        this.addBean(this.scheduler);
        this.addBean(bufferPool);
        this.contextClassloader = Thread.currentThread().getContextClassLoader();
        this.registeredSocketClasses = new ArrayList();
        this.defaultPolicy = policy;
        this.eventDriverFactory = new EventDriverFactory(this.defaultPolicy);
        this.bufferPool = bufferPool;
        this.extensionFactory = new WebSocketExtensionFactory(this.defaultPolicy, this.bufferPool);
        this.extensionFactory.unregister("deflate-frame");
        this.extensionFactory.unregister("permessage-deflate");
        this.extensionFactory.unregister("x-webkit-deflate-frame");
        this.sessionFactories = new ArrayList<SessionFactory>();
        this.sessionFactories.add((SessionFactory)new WebSocketSessionFactory(new SessionListener[]{this}));
        this.creator = this;
        ArrayList<Integer> versions = new ArrayList<Integer>();
        for (int v : this.handshakes.keySet()) {
            versions.add(v);
        }
        Collections.sort(versions, Collections.reverseOrder());
        StringBuilder rv = new StringBuilder();
        Iterator iterator = versions.iterator();
        while (iterator.hasNext()) {
            int v = (Integer)iterator.next();
            if (rv.length() > 0) {
                rv.append(", ");
            }
            rv.append(v);
        }
        this.supportedVersions = rv.toString();
    }

    public boolean acceptWebSocket(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.acceptWebSocket(this.getCreator(), request, response);
    }

    public boolean acceptWebSocket(WebSocketCreator creator, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.contextClassloader);
            ServletUpgradeRequest sockreq = new ServletUpgradeRequest(request);
            ServletUpgradeResponse sockresp = new ServletUpgradeResponse(response);
            Object websocketPojo = creator.createWebSocket(sockreq, sockresp);
            if (sockresp.isCommitted()) {
                boolean bl = false;
                return bl;
            }
            if (websocketPojo == null) {
                sockresp.sendError(503, "Endpoint Creation Failed");
                boolean bl = false;
                return bl;
            }
            HttpConnection connection = (HttpConnection)request.getAttribute("org.eclipse.jetty.server.HttpConnection");
            EventDriver driver = this.eventDriverFactory.wrap(websocketPojo);
            boolean bl = this.upgrade(connection, sockreq, sockresp, driver);
            return bl;
        }
        catch (URISyntaxException e) {
            throw new IOException("Unable to accept websocket due to mangled URI", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void addSessionFactory(SessionFactory sessionFactory) {
        if (this.sessionFactories.contains(sessionFactory)) {
            return;
        }
        this.sessionFactories.add(sessionFactory);
    }

    public void cleanup() {
        try {
            this.stop();
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    protected void shutdownAllConnections() {
        for (WebSocketSession session : this.openSessions) {
            if (session.getConnection() == null) continue;
            try {
                session.getConnection().close(1001, "Shutdown");
            }
            catch (Throwable t) {
                LOG.debug("During Shutdown All Connections", t);
            }
        }
        this.openSessions.clear();
    }

    public WebSocketServletFactory createFactory(WebSocketPolicy policy) {
        return new WebSocketServerFactory(policy, this.bufferPool);
    }

    private WebSocketSession createSession(URI requestURI, EventDriver websocket, LogicalConnection connection) {
        if (websocket == null) {
            throw new InvalidWebSocketException("Unable to create Session from null websocket");
        }
        for (SessionFactory impl : this.sessionFactories) {
            if (!impl.supports(websocket)) continue;
            try {
                return impl.createSession(requestURI, websocket, connection);
            }
            catch (Throwable e) {
                throw new InvalidWebSocketException("Unable to create Session", e);
            }
        }
        throw new InvalidWebSocketException("Unable to create Session: unrecognized internal EventDriver type: " + websocket.getClass().getName());
    }

    public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
        if (this.registeredSocketClasses.size() < 1) {
            throw new WebSocketException("No WebSockets have been registered with the factory.  Cannot use default implementation of WebSocketCreator.");
        }
        if (this.registeredSocketClasses.size() > 1) {
            LOG.warn("You have registered more than 1 websocket object, and are using the default WebSocketCreator! Using first registered websocket.", new Object[0]);
        }
        Class<?> firstClass = this.registeredSocketClasses.get(0);
        try {
            return firstClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new WebSocketException("Unable to create instance of " + firstClass, (Throwable)e);
        }
    }

    protected void doStop() throws Exception {
        this.shutdownAllConnections();
        super.doStop();
    }

    public WebSocketCreator getCreator() {
        return this.creator;
    }

    public EventDriverFactory getEventDriverFactory() {
        return this.eventDriverFactory;
    }

    public ExtensionFactory getExtensionFactory() {
        return this.extensionFactory;
    }

    public Set<WebSocketSession> getOpenSessions() {
        return Collections.unmodifiableSet(this.openSessions);
    }

    public WebSocketPolicy getPolicy() {
        return this.defaultPolicy;
    }

    public void init() throws Exception {
        this.start();
    }

    public boolean isUpgradeRequest(HttpServletRequest request, HttpServletResponse response) {
        String upgrade = request.getHeader("Upgrade");
        if (upgrade == null) {
            return false;
        }
        if (!"websocket".equalsIgnoreCase(upgrade)) {
            return false;
        }
        String connection = request.getHeader("Connection");
        if (connection == null) {
            return false;
        }
        boolean foundUpgradeToken = false;
        Iterator iter = QuoteUtil.splitAt((String)connection, (String)",");
        while (iter.hasNext()) {
            String token = (String)iter.next();
            if (!"upgrade".equalsIgnoreCase(token)) continue;
            foundUpgradeToken = true;
            break;
        }
        if (!foundUpgradeToken) {
            return false;
        }
        if (!"GET".equalsIgnoreCase(request.getMethod())) {
            return false;
        }
        if (!"HTTP/1.1".equals(request.getProtocol())) {
            LOG.debug("Not a 'HTTP/1.1' request (was [" + request.getProtocol() + "])", new Object[0]);
            return false;
        }
        return true;
    }

    public void onSessionClosed(WebSocketSession session) {
        this.openSessions.remove(session);
    }

    public void onSessionOpened(WebSocketSession session) {
        this.openSessions.add(session);
    }

    protected String[] parseProtocols(String protocol) {
        if (protocol == null) {
            return new String[]{null};
        }
        if ((protocol = protocol.trim()).length() == 0) {
            return new String[]{null};
        }
        String[] passed = protocol.split("\\s*,\\s*");
        String[] protocols = new String[passed.length + 1];
        System.arraycopy(passed, 0, protocols, 0, passed.length);
        return protocols;
    }

    public void register(Class<?> websocketPojo) {
        this.registeredSocketClasses.add(websocketPojo);
    }

    public void setCreator(WebSocketCreator creator) {
        this.creator = creator;
    }

    private boolean upgrade(HttpConnection http, ServletUpgradeRequest request, ServletUpgradeResponse response, EventDriver driver) throws IOException {
        WebSocketHandshake handshaker;
        if (!"websocket".equalsIgnoreCase(request.getHeader("Upgrade"))) {
            throw new IllegalStateException("Not a 'WebSocket: Upgrade' request");
        }
        if (!"HTTP/1.1".equals(request.getHttpVersion())) {
            throw new IllegalStateException("Not a 'HTTP/1.1' request");
        }
        int version = request.getHeaderInt("Sec-WebSocket-Version");
        if (version < 0) {
            version = request.getHeaderInt("Sec-WebSocket-Draft");
        }
        if ((handshaker = this.handshakes.get(version)) == null) {
            StringBuilder warn = new StringBuilder();
            warn.append("Client ").append(request.getRemoteAddress());
            warn.append(" (:").append(request.getRemotePort());
            warn.append(") User Agent: ");
            String ua = request.getHeader("User-Agent");
            if (ua == null) {
                warn.append("[unset] ");
            } else {
                warn.append('\"').append(StringUtil.sanitizeXmlString((String)ua)).append("\" ");
            }
            warn.append("requested WebSocket version [").append(version);
            warn.append("], Jetty supports version");
            if (this.handshakes.size() > 1) {
                warn.append('s');
            }
            warn.append(": [").append(this.supportedVersions).append("]");
            LOG.warn(warn.toString(), new Object[0]);
            response.setHeader("Sec-WebSocket-Version", this.supportedVersions);
            response.sendError(400, "Unsupported websocket version specification");
            return false;
        }
        ExtensionStack extensionStack = new ExtensionStack(this.getExtensionFactory());
        if (response.isExtensionsNegotiated()) {
            extensionStack.negotiate(response.getExtensions());
        } else {
            extensionStack.negotiate(request.getExtensions());
        }
        EndPoint endp = http.getEndPoint();
        Executor executor = http.getConnector().getExecutor();
        ByteBufferPool bufferPool = http.getConnector().getByteBufferPool();
        WebSocketServerConnection wsConnection = new WebSocketServerConnection(endp, executor, this.scheduler, driver.getPolicy(), bufferPool);
        extensionStack.setPolicy(driver.getPolicy());
        extensionStack.configure(wsConnection.getParser());
        extensionStack.configure(wsConnection.getGenerator());
        if (LOG.isDebugEnabled()) {
            LOG.debug("HttpConnection: {}", new Object[]{http});
            LOG.debug("WebSocketConnection: {}", new Object[]{wsConnection});
        }
        WebSocketSession session = this.createSession(request.getRequestURI(), driver, (LogicalConnection)wsConnection);
        session.setPolicy(driver.getPolicy());
        session.setUpgradeRequest((UpgradeRequest)request);
        response.setExtensions(extensionStack.getNegotiatedExtensions());
        session.setUpgradeResponse((UpgradeResponse)response);
        wsConnection.setSession(session);
        wsConnection.setNextIncomingFrames((IncomingFrames)extensionStack);
        extensionStack.setNextIncoming((IncomingFrames)session);
        session.setOutgoingHandler((OutgoingFrames)extensionStack);
        extensionStack.setNextOutgoing((OutgoingFrames)wsConnection);
        try {
            session.start();
        }
        catch (Exception e) {
            throw new IOException("Unable to start Session", e);
        }
        try {
            extensionStack.start();
        }
        catch (Exception e) {
            throw new IOException("Unable to start Extension Stack", e);
        }
        request.setServletAttribute("org.eclipse.jetty.server.HttpConnection.UPGRADE", (Object)wsConnection);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handshake Response: {}", new Object[]{handshaker});
        }
        handshaker.doHandshakeResponse(request, response);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Websocket upgrade {} {} {} {}", new Object[]{request.getRequestURI(), version, response.getAcceptedSubProtocol(), wsConnection});
        }
        return true;
    }
}

