/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.jasperreports.data.cache.DataCacheHandler;
import net.sf.jasperreports.data.cache.DataRecorder;
import net.sf.jasperreports.data.cache.DataSnapshot;
import net.sf.jasperreports.engine.Deduplicable;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.fill.BaseReportFiller;
import net.sf.jasperreports.engine.fill.FillDatasetPosition;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import net.sf.jasperreports.engine.util.DeduplicableRegistry;
import net.sf.jasperreports.engine.util.FormatFactory;
import net.sf.jasperreports.engine.util.JRStyledTextUtil;
import net.sf.jasperreports.engine.util.Pair;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.RenderersCache;
import net.sf.jasperreports.repo.JasperDesignCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRFillContext {
    private static final Log log = LogFactory.getLog(JRFillContext.class);
    private final BaseReportFiller masterFiller;
    private Map<Object, Renderable> loadedImageRenderers;
    private RenderersCache renderersCache;
    private Map<Object, JasperReport> loadedSubreports;
    private Map<Object, JRTemplate> loadedTemplates;
    private DeduplicableRegistry deduplicableRegistry;
    private boolean usingVirtualizer;
    private JRPrintPage printPage;
    private JRQueryExecuter queryExecuter;
    private JasperReportsContext jasperReportsContext;
    private JRStyledTextUtil styledTextUtil;
    private ReportContext reportContext;
    private DataCacheHandler cacheHandler;
    private DataSnapshot dataSnapshot;
    private DataRecorder dataRecorder;
    private List<Pair<FillDatasetPosition, Object>> recordedData;
    private JRVirtualizationContext virtualizationContext;
    private FormatFactory masterFormatFactory;
    private Locale masterLocale;
    private TimeZone masterTimeZone;
    private volatile boolean canceled;
    private final AtomicInteger fillerIdSeq = new AtomicInteger();
    private final AtomicInteger fillElementSeq = new AtomicInteger();
    private Map<String, Object> fillCaches = new HashMap<String, Object>();
    private final boolean legacyElementStretchEnabled;

    public JRFillContext(BaseReportFiller masterFiller) {
        this.masterFiller = masterFiller;
        this.jasperReportsContext = masterFiller.getJasperReportsContext();
        this.styledTextUtil = JRStyledTextUtil.getInstance(this.jasperReportsContext);
        this.loadedImageRenderers = new HashMap<Object, Renderable>();
        this.renderersCache = new RenderersCache(this.jasperReportsContext);
        this.loadedSubreports = new HashMap<Object, JasperReport>();
        this.loadedTemplates = new HashMap<Object, JRTemplate>();
        this.deduplicableRegistry = new DeduplicableRegistry();
        FontUtil.getInstance(this.jasperReportsContext).resetThreadMissingFontsCache();
        this.legacyElementStretchEnabled = JRPropertiesUtil.getInstance(this.jasperReportsContext).getBooleanProperty("net.sf.jasperreports.legacy.element.stretch.enabled");
    }

    public BaseReportFiller getMasterFiller() {
        return this.masterFiller;
    }

    protected JRStyledTextUtil getStyledTextUtil() {
        return this.styledTextUtil;
    }

    public boolean hasLoadedRenderer(Object source) {
        return this.loadedImageRenderers.containsKey(source);
    }

    public Renderable getLoadedRenderer(Object source) {
        return this.loadedImageRenderers.get(source);
    }

    public void registerLoadedRenderer(Object source, Renderable renderer) {
        this.loadedImageRenderers.put(source, renderer);
        if (this.usingVirtualizer) {
            this.virtualizationContext.cacheRenderer(renderer);
        }
    }

    public RenderersCache getRenderersCache() {
        return this.renderersCache;
    }

    public boolean hasLoadedSubreport(Object source) {
        return this.loadedSubreports.containsKey(source);
    }

    public JasperReport getLoadedSubreport(Object source) {
        return this.loadedSubreports.get(source);
    }

    public void registerLoadedSubreport(Object source, JasperReport subreport) {
        this.loadedSubreports.put(source, subreport);
    }

    public void setUsingVirtualizer(boolean usingVirtualizer) {
        this.usingVirtualizer = usingVirtualizer;
        if (usingVirtualizer && this.virtualizationContext == null) {
            this.virtualizationContext = new JRVirtualizationContext(this.jasperReportsContext);
        }
    }

    public boolean isUsingVirtualizer() {
        return this.usingVirtualizer;
    }

    public void setPrintPage(JRPrintPage page) {
        this.printPage = page;
    }

    public JRPrintPage getPrintPage() {
        return this.printPage;
    }

    public boolean isIgnorePagination() {
        return this.masterFiller.isIgnorePagination();
    }

    public boolean isLegacyElementStretchEnabled() {
        return this.legacyElementStretchEnabled;
    }

    public synchronized void setRunningQueryExecuter(JRQueryExecuter queryExecuter) {
        this.queryExecuter = queryExecuter;
    }

    public synchronized void clearRunningQueryExecuter() {
        this.queryExecuter = null;
    }

    public synchronized boolean cancelRunningQuery() throws JRException {
        if (this.queryExecuter != null) {
            return this.queryExecuter.cancelQuery();
        }
        return false;
    }

    public JRVirtualizationContext getVirtualizationContext() {
        return this.virtualizationContext;
    }

    public void lockVirtualizationContext() {
        if (this.virtualizationContext != null) {
            this.virtualizationContext.lock();
        }
    }

    public void unlockVirtualizationContext() {
        if (this.virtualizationContext != null) {
            this.virtualizationContext.unlock();
        }
    }

    public FormatFactory getMasterFormatFactory() {
        return this.masterFormatFactory;
    }

    public void setMasterFormatFactory(FormatFactory masterFormatFactory) {
        this.masterFormatFactory = masterFormatFactory;
    }

    public Locale getMasterLocale() {
        return this.masterLocale;
    }

    public void setMasterLocale(Locale masterLocale) {
        this.masterLocale = masterLocale;
    }

    public TimeZone getMasterTimeZone() {
        return this.masterTimeZone;
    }

    public void setMasterTimeZone(TimeZone masterTimeZone) {
        this.masterTimeZone = masterTimeZone;
    }

    public boolean hasLoadedTemplate(Object source) {
        return this.loadedTemplates.containsKey(source);
    }

    public JRTemplate getLoadedTemplate(Object source) {
        return this.loadedTemplates.get(source);
    }

    public void registerLoadedTemplate(Object source, JRTemplate template) {
        this.loadedTemplates.put(source, template);
    }

    public <T extends Deduplicable> T deduplicate(T object) {
        return this.deduplicableRegistry.deduplicate(object);
    }

    public int generateFillElementId() {
        return this.fillElementSeq.incrementAndGet();
    }

    protected int generatedFillerId() {
        return this.fillerIdSeq.incrementAndGet();
    }

    public ReportContext getReportContext() {
        return this.reportContext;
    }

    public void setReportContext(ReportContext reportContext) {
        this.reportContext = reportContext;
        this.cacheHandler = (DataCacheHandler)this.getContextParameterValue("net.sf.jasperreports.data.cache.handler");
        if (this.cacheHandler != null) {
            if (this.cacheHandler.isSnapshotPopulated()) {
                this.dataSnapshot = this.cacheHandler.getDataSnapshot();
            } else if (this.cacheHandler.isRecordingEnabled()) {
                this.dataRecorder = this.cacheHandler.createDataRecorder();
                this.recordedData = new ArrayList<Pair<FillDatasetPosition, Object>>();
            }
        }
    }

    protected Object getContextParameterValue(String parameterName) {
        if (this.reportContext == null) {
            return null;
        }
        Object value = this.reportContext.getParameterValue(parameterName);
        return value;
    }

    public DataCacheHandler getCacheHandler() {
        return this.cacheHandler;
    }

    public DataSnapshot getDataSnapshot() {
        return this.dataSnapshot;
    }

    public boolean hasDataSnapshot() {
        return this.dataSnapshot != null;
    }

    public DataRecorder getDataRecorder() {
        return this.dataRecorder;
    }

    public void addDataRecordResult(FillDatasetPosition fillPosition, Object recorded) {
        this.recordedData.add(new Pair<FillDatasetPosition, Object>(fillPosition, recorded));
    }

    public void cacheDone() {
        if (this.dataRecorder != null && this.dataRecorder.isEnabled()) {
            for (Pair<FillDatasetPosition, Object> recorededItem : this.recordedData) {
                this.dataRecorder.addRecordResult(recorededItem.first(), recorededItem.second());
            }
            this.dataRecorder.setSnapshotPopulated();
        }
    }

    public void markCanceled() {
        this.canceled = true;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public Object getFillCache(String key) {
        return this.fillCaches.get(key);
    }

    public void setFillCache(String key, Object value) {
        this.fillCaches.put(key, value);
    }

    public void dispose() {
        for (Object cacheObject : this.fillCaches.values()) {
            if (!(cacheObject instanceof FillCacheDisposable)) continue;
            ((FillCacheDisposable)cacheObject).dispose();
        }
    }

    public boolean isCollectingBookmarks() {
        return this.getMasterFiller().bookmarkHelper != null;
    }

    public void registerReportStyles(JasperReport jasperReport, UUID id, List<JRStyle> styles) {
        JasperDesignCache designCache = JasperDesignCache.getExistingInstance(this.reportContext);
        if (designCache != null) {
            String reportURI = designCache.locateReport(jasperReport);
            if (reportURI == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Did not find report " + jasperReport.getName() + " " + jasperReport.getUUID()));
                }
                return;
            }
            designCache.setStyles(reportURI, id, styles);
        }
    }

    public void registerReportStyles(String reportLocation, UUID id, List<JRStyle> styles) {
        JasperDesignCache designCache = JasperDesignCache.getExistingInstance(this.reportContext);
        if (designCache != null) {
            designCache.setStyles(reportLocation, id, styles);
        }
    }

    public static interface FillCacheDisposable {
        public void dispose();
    }
}

