/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.descriptor;

import com.cronutils.descriptor.DescriptionStrategy;
import com.cronutils.descriptor.NominalDescriptionStrategy;
import com.cronutils.descriptor.TimeDescriptionStrategy;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.On;
import java.time.DayOfWeek;
import java.time.Month;
import java.time.format.TextStyle;
import java.util.ResourceBundle;
import java.util.function.Function;

class DescriptionStrategyFactory {
    private DescriptionStrategyFactory() {
    }

    public static DescriptionStrategy daysOfWeekInstance(ResourceBundle bundle, FieldExpression expression) {
        Function<Integer, String> nominal = integer -> DayOfWeek.of(integer).getDisplayName(TextStyle.FULL, bundle.getLocale());
        NominalDescriptionStrategy dow = new NominalDescriptionStrategy(bundle, nominal, expression);
        dow.addDescription(fieldExpression -> {
            if (fieldExpression instanceof On) {
                On on = (On)fieldExpression;
                switch (on.getSpecialChar().getValue()) {
                    case HASH: {
                        return String.format("%s %s %s ", nominal.apply(on.getTime().getValue()), on.getNth(), bundle.getString("of_every_month"));
                    }
                    case L: {
                        return String.format("%s %s %s ", bundle.getString("last"), nominal.apply(on.getTime().getValue()), bundle.getString("of_every_month"));
                    }
                }
                return "";
            }
            return "";
        });
        return dow;
    }

    public static DescriptionStrategy daysOfMonthInstance(ResourceBundle bundle, FieldExpression expression) {
        NominalDescriptionStrategy dom = new NominalDescriptionStrategy(bundle, null, expression);
        dom.addDescription(fieldExpression -> {
            if (fieldExpression instanceof On) {
                On on = (On)fieldExpression;
                switch (on.getSpecialChar().getValue()) {
                    case W: {
                        return String.format("%s %s %s ", bundle.getString("the_nearest_weekday_to_the"), on.getTime().getValue(), bundle.getString("of_the_month"));
                    }
                    case L: {
                        return bundle.getString("last_day_of_month");
                    }
                    case LW: {
                        return bundle.getString("last_weekday_of_month");
                    }
                }
                return "";
            }
            return "";
        });
        return dom;
    }

    public static DescriptionStrategy monthsInstance(ResourceBundle bundle, FieldExpression expression) {
        return new NominalDescriptionStrategy(bundle, integer -> Month.of(integer).getDisplayName(TextStyle.FULL, bundle.getLocale()), expression);
    }

    public static DescriptionStrategy plainInstance(ResourceBundle bundle, FieldExpression expression) {
        return new NominalDescriptionStrategy(bundle, null, expression);
    }

    public static DescriptionStrategy hhMMssInstance(ResourceBundle bundle, FieldExpression hours, FieldExpression minutes, FieldExpression seconds) {
        return new TimeDescriptionStrategy(bundle, hours, minutes, seconds);
    }
}

