/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.prettyprint.cassandra.model.HColumnImpl;
import me.prettyprint.cassandra.utils.Assert;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.ColumnSlice;
import me.prettyprint.hector.api.beans.HColumn;
import org.apache.cassandra.thrift.Column;

public final class ColumnSliceImpl<N, V>
implements ColumnSlice<N, V> {
    private final Map<N, HColumn<N, V>> columnsMap;
    private final List<HColumn<N, V>> columnsList;

    public ColumnSliceImpl(List<Column> tColumns, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        Assert.noneNull(tColumns, nameSerializer, valueSerializer);
        this.columnsMap = new HashMap<N, HColumn<N, V>>(tColumns.size());
        ArrayList<HColumnImpl<N, V>> list = new ArrayList<HColumnImpl<N, V>>(tColumns.size());
        for (Column c : tColumns) {
            HColumnImpl<N, V> column = new HColumnImpl<N, V>(c, nameSerializer, valueSerializer);
            this.columnsMap.put(column.getName(), column);
            list.add(column);
        }
        this.columnsList = Collections.unmodifiableList(list);
    }

    @Override
    public List<HColumn<N, V>> getColumns() {
        return this.columnsList;
    }

    @Override
    public HColumn<N, V> getColumnByName(N columnName) {
        return this.columnsMap.get(columnName);
    }

    public String toString() {
        return "ColumnSlice(" + this.columnsList + ")";
    }
}

