/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import me.prettyprint.cassandra.service.CassandraHost;

public class ExecutionResult<T> {
    private final T value;
    private final long execTime;
    private final CassandraHost cassandraHost;
    protected static final String BASE_MSG_FORMAT = "%s took (%dus) for query (%s) on host: %s";

    public ExecutionResult(T value, long execTime, CassandraHost cassandraHost) {
        this.value = value;
        this.execTime = execTime;
        this.cassandraHost = cassandraHost;
    }

    public T get() {
        return this.value;
    }

    public long getExecutionTimeMicro() {
        return this.execTime;
    }

    public String toString() {
        return this.formatMessage("ExecutionResult", "n/a");
    }

    protected String formatMessage(String resultName, String query) {
        return String.format(BASE_MSG_FORMAT, resultName, this.execTime, query, this.cassandraHost != null ? this.cassandraHost.getName() : "[none]");
    }

    public CassandraHost getHostUsed() {
        return this.cassandraHost;
    }
}

