/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import java.util.Arrays;
import me.prettyprint.cassandra.model.ExecutingKeyspace;
import me.prettyprint.cassandra.model.HColumnImpl;
import me.prettyprint.cassandra.model.HSuperColumnImpl;
import me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import me.prettyprint.cassandra.model.MutationResultImpl;
import me.prettyprint.cassandra.model.thrift.ThriftFactory;
import me.prettyprint.cassandra.serializers.TypeInferringSerializer;
import me.prettyprint.cassandra.service.BatchMutation;
import me.prettyprint.cassandra.service.KeyspaceService;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.beans.HSuperColumn;
import me.prettyprint.hector.api.exceptions.HectorException;
import me.prettyprint.hector.api.mutation.MutationResult;
import me.prettyprint.hector.api.mutation.Mutator;
import org.apache.cassandra.thrift.Deletion;
import org.apache.cassandra.thrift.SlicePredicate;

public final class MutatorImpl<K>
implements Mutator<K> {
    private final ExecutingKeyspace keyspace;
    protected final Serializer<K> keySerializer;
    private BatchMutation<K> pendingMutations;

    public MutatorImpl(Keyspace keyspace, Serializer<K> keySerializer) {
        this.keyspace = (ExecutingKeyspace)keyspace;
        this.keySerializer = keySerializer;
    }

    public MutatorImpl(Keyspace keyspace) {
        this(keyspace, TypeInferringSerializer.get());
    }

    @Override
    public <N, V> MutationResult insert(K key, String cf, HColumn<N, V> c) {
        this.addInsertion(key, cf, c);
        return this.execute();
    }

    @Override
    public <SN, N, V> MutationResult insert(K key, String cf, HSuperColumn<SN, N, V> superColumn) {
        this.addInsertion(key, cf, superColumn);
        return this.execute();
    }

    @Override
    public <N> MutationResult delete(K key, String cf, N columnName, Serializer<N> nameSerializer) {
        this.addDeletion(key, cf, columnName, nameSerializer);
        return this.execute();
    }

    @Override
    public <SN, N> MutationResult subDelete(final K key, final String cf, final SN supercolumnName, final N columnName, final Serializer<SN> sNameSerializer, final Serializer<N> nameSerializer) {
        return new MutationResultImpl(this.keyspace.doExecute(new KeyspaceOperationCallback<Void>(){

            @Override
            public Void doInKeyspace(KeyspaceService ks) throws HectorException {
                ks.remove(MutatorImpl.this.keySerializer.toByteBuffer(key), ThriftFactory.createSuperColumnPath(cf, supercolumnName, columnName, sNameSerializer, nameSerializer));
                return null;
            }
        }));
    }

    @Override
    public <N, V> Mutator<K> addInsertion(K key, String cf, HColumn<N, V> c) {
        this.getPendingMutations().addInsertion(key, Arrays.asList(cf), ((HColumnImpl)c).toThrift());
        return this;
    }

    @Override
    public <SN, N, V> Mutator<K> addInsertion(K key, String cf, HSuperColumn<SN, N, V> sc) {
        this.getPendingMutations().addSuperInsertion(key, Arrays.asList(cf), ((HSuperColumnImpl)sc).toThrift());
        return this;
    }

    @Override
    public <N> Mutator<K> addDeletion(K key, String cf, N columnName, Serializer<N> nameSerializer) {
        this.addDeletion(key, cf, columnName, nameSerializer, this.keyspace.createClock());
        return this;
    }

    @Override
    public <N> Mutator<K> addDeletion(K key, String cf, N columnName, Serializer<N> nameSerializer, long clock) {
        SlicePredicate sp = new SlicePredicate();
        sp.addToColumn_names(nameSerializer.toByteBuffer(columnName));
        Deletion d = columnName != null ? new Deletion(clock).setPredicate(sp) : new Deletion(clock);
        this.getPendingMutations().addDeletion(key, Arrays.asList(cf), d);
        return this;
    }

    @Override
    public MutationResult execute() {
        if (this.pendingMutations == null || this.pendingMutations.isEmpty()) {
            return new MutationResultImpl(true, 0L, null);
        }
        final BatchMutation<K> mutations = this.pendingMutations.makeCopy();
        this.pendingMutations = null;
        return new MutationResultImpl(this.keyspace.doExecute(new KeyspaceOperationCallback<Void>(){

            @Override
            public Void doInKeyspace(KeyspaceService ks) throws HectorException {
                ks.batchMutate(mutations);
                return null;
            }
        }));
    }

    @Override
    public Mutator<K> discardPendingMutations() {
        this.pendingMutations = null;
        return this;
    }

    public String toString() {
        return "Mutator(" + this.keyspace.toString() + ")";
    }

    private BatchMutation<K> getPendingMutations() {
        if (this.pendingMutations == null) {
            this.pendingMutations = new BatchMutation<K>(this.keySerializer);
        }
        return this.pendingMutations;
    }
}

