/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.io.Serializable;
import me.prettyprint.cassandra.connection.LoadBalancingPolicy;
import me.prettyprint.cassandra.connection.RoundRobinBalancingPolicy;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.cassandra.service.ExhaustedPolicy;
import me.prettyprint.hector.api.ClockResolution;
import me.prettyprint.hector.api.factory.HFactory;

public final class CassandraHostConfigurator
implements Serializable {
    private static final long serialVersionUID = -5798876803582956262L;
    private String hosts;
    private int port = 9160;
    private int maxActive = 50;
    private int maxIdle = -1;
    private boolean lifo = true;
    private long minEvictableIdleTimeMillis = 1800000L;
    private long timeBetweenEvictionRunsMillis = -1L;
    private long maxWaitTimeWhenExhausted = -1L;
    private int cassandraThriftSocketTimeout;
    private ExhaustedPolicy exhaustedPolicy;
    private ClockResolution clockResolution = HFactory.createClockResolution("MICROSECONDS");
    private boolean useThriftFramedTransport = true;
    private boolean retryDownedHosts = true;
    private boolean autoDiscoverHosts = false;
    private int retryDownedHostsQueueSize = 3;
    private int retryDownedHostsDelayInSeconds = 10;
    private int autoDiscoveryDelayInSeconds = 30;
    private LoadBalancingPolicy loadBalancingPolicy = new RoundRobinBalancingPolicy();

    public CassandraHostConfigurator() {
        this.hosts = null;
    }

    public CassandraHostConfigurator(String hosts) {
        this.hosts = hosts;
    }

    public CassandraHost[] buildCassandraHosts() {
        if (this.hosts == null) {
            return null;
        }
        String[] hostVals = this.hosts.split(",");
        CassandraHost[] cassandraHosts = new CassandraHost[hostVals.length];
        for (int x = 0; x < hostVals.length; ++x) {
            CassandraHost cassandraHost = this.port == 9160 ? new CassandraHost(hostVals[x]) : new CassandraHost(hostVals[x], this.port);
            this.applyConfig(cassandraHost);
            cassandraHosts[x] = cassandraHost;
        }
        return cassandraHosts;
    }

    public void applyConfig(CassandraHost cassandraHost) {
        cassandraHost.setMaxActive(this.maxActive);
        cassandraHost.setMaxIdle(this.maxIdle);
        cassandraHost.setLifo(this.lifo);
        cassandraHost.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
        cassandraHost.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
        cassandraHost.setMaxWaitTimeWhenExhausted(this.maxWaitTimeWhenExhausted);
        cassandraHost.setUseThriftFramedTransport(this.useThriftFramedTransport);
        if (this.cassandraThriftSocketTimeout > 0) {
            cassandraHost.setCassandraThriftSocketTimeout(this.cassandraThriftSocketTimeout);
        }
        if (this.exhaustedPolicy != null) {
            cassandraHost.setExhaustedPolicy(this.exhaustedPolicy);
        }
        if (this.clockResolution != null) {
            cassandraHost.setClockResolution(this.clockResolution);
        }
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public void setMaxWaitTimeWhenExhausted(long maxWaitTimeWhenExhausted) {
        this.maxWaitTimeWhenExhausted = maxWaitTimeWhenExhausted;
    }

    public void setCassandraThriftSocketTimeout(int cassandraThriftSocketTimeout) {
        this.cassandraThriftSocketTimeout = cassandraThriftSocketTimeout;
    }

    public void setExhaustedPolicy(ExhaustedPolicy exhaustedPolicy) {
        this.exhaustedPolicy = exhaustedPolicy;
    }

    public boolean getRetryDownedHosts() {
        return this.retryDownedHosts;
    }

    public void setRetryDownedHosts(boolean retryDownedHosts) {
        this.retryDownedHosts = retryDownedHosts;
    }

    public void setRetryDownedHostsQueueSize(int retryDownedHostsQueueSize) {
        this.retryDownedHostsQueueSize = retryDownedHostsQueueSize;
    }

    public int getRetryDownedHostsQueueSize() {
        return this.retryDownedHostsQueueSize;
    }

    public void setRetryDownedHostsDelayInSeconds(int retryDownedHostsDelayInSeconds) {
        this.retryDownedHostsDelayInSeconds = retryDownedHostsDelayInSeconds;
    }

    public int getRetryDownedHostsDelayInSeconds() {
        return this.retryDownedHostsDelayInSeconds;
    }

    public void setClockResolution(String resolutionString) {
        this.clockResolution = HFactory.createClockResolution(resolutionString);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("CassandraHostConfigurator<");
        s.append("clockResolution=");
        s.append(this.clockResolution);
        s.append("&exhaustedPolicy=");
        s.append((Object)this.exhaustedPolicy);
        s.append("&cassandraThriftSocketTimeout=");
        s.append(this.cassandraThriftSocketTimeout);
        s.append("&maxWaitTimeWhenExhausted=");
        s.append(this.maxWaitTimeWhenExhausted);
        s.append("&maxIdle=");
        s.append(this.maxIdle);
        s.append("&maxActive=");
        s.append(this.maxActive);
        s.append("&hosts=");
        s.append(this.hosts);
        s.append("&useThriftFramedTransport=");
        s.append(this.useThriftFramedTransport);
        s.append("&retryDownedHosts=");
        s.append(this.retryDownedHosts);
        s.append(">");
        return s.toString();
    }

    public boolean getLifo() {
        return this.lifo;
    }

    public void setLifo(boolean lifo) {
        this.lifo = lifo;
    }

    public long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUseThriftFramedTransport(boolean useThriftFramedTransport) {
        this.useThriftFramedTransport = useThriftFramedTransport;
    }

    public ClockResolution getClockResolution() {
        return this.clockResolution;
    }

    public void setClockResolution(ClockResolution clockResolution) {
        this.clockResolution = clockResolution;
    }

    public boolean getAutoDiscoverHosts() {
        return this.autoDiscoverHosts;
    }

    public void setAutoDiscoverHosts(boolean autoDiscoverHosts) {
        this.autoDiscoverHosts = autoDiscoverHosts;
    }

    public int getAutoDiscoveryDelayInSeconds() {
        return this.autoDiscoveryDelayInSeconds;
    }

    public void setAutoDiscoveryDelayInSeconds(int autoDiscoveryDelayInSeconds) {
        this.autoDiscoveryDelayInSeconds = autoDiscoveryDelayInSeconds;
    }

    public LoadBalancingPolicy getLoadBalancingPolicy() {
        return this.loadBalancingPolicy;
    }

    public void setLoadBalancingPolicy(LoadBalancingPolicy loadBalancingPolicy) {
        this.loadBalancingPolicy = loadBalancingPolicy;
    }
}

