/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import me.prettyprint.cassandra.connection.HConnectionManager;
import me.prettyprint.cassandra.service.CassandraClientMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxMonitor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private MBeanServer mbs;
    private CassandraClientMonitor cassandraClientMonitor;
    private static JmxMonitor monitorInstance;

    private JmxMonitor(HConnectionManager connectionManager) {
        CassandraClientMonitor cassandraClientMonitor = new CassandraClientMonitor(connectionManager);
        this.mbs = ManagementFactory.getPlatformMBeanServer();
        this.cassandraClientMonitor = cassandraClientMonitor;
        try {
            this.registerMonitor("me.prettyprint.cassandra.service", "hector", cassandraClientMonitor);
        }
        catch (MalformedObjectNameException e) {
            this.log.error("Unable to register JMX monitor", (Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            this.log.error("Unable to register JMX monitor", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            this.log.error("Unable to register JMX monitor", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            this.log.error("Unable to register JMX monitor", (Throwable)e);
        }
    }

    public static JmxMonitor getInstance(HConnectionManager connectionManager) {
        if (monitorInstance == null) {
            monitorInstance = new JmxMonitor(connectionManager);
        }
        return monitorInstance;
    }

    public void registerMonitor(String name, String monitorType, Object monitoringInterface) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        String monitorName = this.generateMonitorName(name, monitorType);
        this.log.info("Registering JMX {}", (Object)monitorName);
        ObjectName oName = new ObjectName(monitorName);
        if (this.mbs.isRegistered(oName)) {
            this.log.info("Monitor already registered: {}", (Object)oName);
            return;
        }
        this.mbs.registerMBean(monitoringInterface, oName);
        if ("true".equalsIgnoreCase(System.getProperty("com.prettyprint.cassandra.load_hector_log4j", "true"))) {
            this.registerPerf4J();
        }
    }

    private void registerPerf4J() {
        URL url = this.getClass().getClassLoader().getResource("hectorLog4j.xml");
        if (url == null) {
            this.log.warn("Unable to locate hectorLog4j.xml; performance counters will not be exported");
        } else {
            try {
                Class<?> domConfiguratorClass = this.getClass().getClassLoader().loadClass("org.apache.log4j.xml.DOMConfigurator");
                Method method = domConfiguratorClass.getMethod("configure", URL.class);
                method.invoke(null, url);
            }
            catch (ClassNotFoundException e) {
                this.log.warn("Unable to load log4j's DOMConfigurator. Performance counters will not be exported. To fix, include the log4j jar in your application's classpath.");
            }
            catch (SecurityException e) {
                this.log.error("Could not access method DOMConfigurator.configure(URL)", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                this.log.error("Could not find method DOMConfigurator.configure(URL)", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                this.log.error("Could not invoke method DOMConfigurator.configure(URL)", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.log.error("Could not invoke method DOMConfigurator.configure(URL)", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    private String generateMonitorName(String className, String monitorType) {
        StringBuilder sb = new StringBuilder();
        sb.append(className);
        sb.append(":ServiceType=");
        sb.append(this.getUniqueClassloaderIdentifier());
        if (null != monitorType && monitorType.length() > 0) {
            sb.append(",MonitorType=" + monitorType);
        }
        return sb.toString();
    }

    private String getUniqueClassloaderIdentifier() {
        String contextPath = this.getContextPath();
        if (contextPath != null) {
            return contextPath;
        }
        return "hector";
    }

    private String getContextPath() {
        URL url = this.getClass().getClassLoader().getResource("/");
        if (url != null) {
            String[] elements = url.toString().split("/");
            for (int i = elements.length - 1; i > 0; --i) {
                if (!"WEB-INF".equals(elements[i])) continue;
                return elements[i - 1];
            }
        }
        return null;
    }

    public CassandraClientMonitor getCassandraMonitor() {
        return this.cassandraClientMonitor;
    }
}

