/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.utils;

import com.eaio.uuid.UUID;
import com.eaio.uuid.UUIDGen;
import java.nio.ByteBuffer;
import me.prettyprint.hector.api.ClockResolution;

public final class TimeUUIDUtils {
    public static java.util.UUID getUniqueTimeUUIDinMillis() {
        return java.util.UUID.fromString(new UUID().toString());
    }

    public static java.util.UUID getTimeUUID(ClockResolution clock) {
        return TimeUUIDUtils.getTimeUUID(clock.createClock());
    }

    public static java.util.UUID getTimeUUID(long time) {
        return new java.util.UUID(TimeUUIDUtils.createTime(time), UUIDGen.getClockSeqAndNode());
    }

    private static long createTime(long currentTime) {
        long timeToUse = currentTime * 10000L + 122192928000000000L;
        long time = timeToUse << 32;
        time |= (timeToUse & 0xFFFF00000000L) >> 16;
        return time |= 0x1000L | timeToUse >> 48 & 0xFFFL;
    }

    public static java.util.UUID toUUID(byte[] uuid) {
        return TimeUUIDUtils.uuid(uuid, 0);
    }

    public static long getTimeFromUUID(byte[] uuid) {
        return TimeUUIDUtils.toUUID(uuid).timestamp();
    }

    public static byte[] asByteArray(java.util.UUID uuid) {
        int i;
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] buffer = new byte[16];
        for (i = 0; i < 8; ++i) {
            buffer[i] = (byte)(msb >>> 8 * (7 - i));
        }
        for (i = 8; i < 16; ++i) {
            buffer[i] = (byte)(lsb >>> 8 * (7 - i));
        }
        return buffer;
    }

    public static ByteBuffer asByteBuffer(java.util.UUID uuid) {
        if (uuid == null) {
            return null;
        }
        return ByteBuffer.wrap(TimeUUIDUtils.asByteArray(uuid));
    }

    public static java.util.UUID uuid(byte[] uuid, int offset) {
        ByteBuffer bb = ByteBuffer.wrap(uuid, offset, 16);
        return new java.util.UUID(bb.getLong(), bb.getLong());
    }

    public static java.util.UUID uuid(ByteBuffer bb) {
        bb = bb.slice();
        return new java.util.UUID(bb.getLong(), bb.getLong());
    }
}

