/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.cassandra.db.commitlog.AbstractCommitLogExecutorService;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.ICommitLogExecutorService;
import org.apache.cassandra.db.commitlog.PeriodicCommitLogExecutorServiceMBean;
import org.apache.cassandra.utils.WrappedRunnable;

class PeriodicCommitLogExecutorService
implements ICommitLogExecutorService,
PeriodicCommitLogExecutorServiceMBean {
    private final BlockingQueue<Runnable> queue;
    protected volatile long completedTaskCount = 0L;

    public PeriodicCommitLogExecutorService() {
        this(1024 * Runtime.getRuntime().availableProcessors());
    }

    public PeriodicCommitLogExecutorService(int queueSize) {
        this.queue = new LinkedBlockingQueue<Runnable>(queueSize);
        WrappedRunnable runnable = new WrappedRunnable(){

            @Override
            public void runMayThrow() throws Exception {
                while (true) {
                    ((Runnable)PeriodicCommitLogExecutorService.this.queue.take()).run();
                    ++PeriodicCommitLogExecutorService.this.completedTaskCount;
                }
            }
        };
        new Thread((Runnable)runnable, "COMMIT-LOG-WRITER").start();
        AbstractCommitLogExecutorService.registerMBean(this);
    }

    @Override
    public void add(CommitLog.LogRecordAdder adder) {
        try {
            this.queue.put(adder);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        FutureTask<T> ft = new FutureTask<T>(task);
        try {
            this.queue.put(ft);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return ft;
    }

    @Override
    public long getPendingTasks() {
        return this.queue.size();
    }

    @Override
    public int getActiveCount() {
        return 1;
    }

    @Override
    public long getCompletedTasks() {
        return this.completedTaskCount;
    }
}

