/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.thrift.TBaseHelper;

public class BytesToken
extends Token<byte[]> {
    public BytesToken(ByteBuffer token) {
        this(TBaseHelper.byteBufferToByteArray((ByteBuffer)token));
    }

    public BytesToken(byte[] token) {
        super(token);
    }

    @Override
    public String toString() {
        return "Token(bytes[" + FBUtilities.bytesToHex((byte[])this.token) + "])";
    }

    @Override
    public int compareTo(Token<byte[]> o) {
        return FBUtilities.compareUnsigned((byte[])this.token, (byte[])o.token, 0, 0, ((byte[])this.token).length, ((byte[])o.token).length);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        return 31 + Arrays.hashCode((byte[])this.token);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BytesToken)) {
            return false;
        }
        BytesToken other = (BytesToken)obj;
        return Arrays.equals((byte[])this.token, (byte[])other.token);
    }
}

