/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.gms.GossipDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GossipDigestSerializationHelper {
    private static Logger logger_ = LoggerFactory.getLogger(GossipDigestSerializationHelper.class);

    GossipDigestSerializationHelper() {
    }

    static void serialize(List<GossipDigest> gDigestList, DataOutputStream dos) throws IOException {
        dos.writeInt(gDigestList.size());
        for (GossipDigest gDigest : gDigestList) {
            GossipDigest.serializer().serialize(gDigest, dos);
        }
    }

    static List<GossipDigest> deserialize(DataInputStream dis) throws IOException {
        int size = dis.readInt();
        ArrayList<GossipDigest> gDigests = new ArrayList<GossipDigest>(size);
        for (int i = 0; i < size; ++i) {
            assert (dis.available() > 0);
            gDigests.add(GossipDigest.serializer().deserialize(dis));
        }
        return gDigests;
    }
}

