/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import org.apache.cassandra.io.util.BufferedRandomAccessFile;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.SegmentedFile;

public class BufferedSegmentedFile
extends SegmentedFile {
    public BufferedSegmentedFile(String path, long length) {
        super(path, length);
    }

    @Override
    public FileDataInput getSegment(long position, int bufferSize) {
        try {
            BufferedRandomAccessFile file = new BufferedRandomAccessFile(this.path, "r", bufferSize);
            file.seek(position);
            return file;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static class Builder
    extends SegmentedFile.Builder {
        @Override
        public void addPotentialBoundary(long boundary) {
        }

        @Override
        public SegmentedFile complete(String path) {
            long length = new File(path).length();
            return new BufferedSegmentedFile(path, length);
        }
    }
}

