/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.jclouds.javax.annotation.Nullable;

public class BlockDeviceMapping
implements Comparable<BlockDeviceMapping> {
    private final String deviceName;
    private final String virtualName;
    private final String snapshotId;
    private final Integer sizeInGib;
    private final Boolean noDevice;
    private final Boolean deleteOnTermination;
    private final String volumeType;
    private final Integer iops;
    private final Boolean encrypted;
    private static final Integer VOLUME_SIZE_MIN_VALUE = 1;
    private static final Integer VOLUME_SIZE_MAX_VALUE = 1000;

    public static Builder builder() {
        return new Builder();
    }

    BlockDeviceMapping(String deviceName, @Nullable String virtualName, @Nullable String snapshotId, @Nullable Integer sizeInGib, @Nullable Boolean noDevice, @Nullable Boolean deleteOnTermination, @Nullable String volumeType, @Nullable Integer iops, @Nullable Boolean encrypted) {
        Preconditions.checkNotNull((Object)deviceName, (Object)"deviceName cannot be null");
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)deviceName), (Object)"deviceName must be defined");
        if (sizeInGib != null) {
            Preconditions.checkArgument((sizeInGib >= VOLUME_SIZE_MIN_VALUE && sizeInGib <= VOLUME_SIZE_MAX_VALUE ? 1 : 0) != 0, (Object)String.format("Size in Gib must be between %s and %s GB", VOLUME_SIZE_MIN_VALUE, VOLUME_SIZE_MAX_VALUE));
        }
        this.deviceName = deviceName;
        this.virtualName = virtualName;
        this.snapshotId = snapshotId;
        this.sizeInGib = sizeInGib;
        this.noDevice = noDevice;
        this.deleteOnTermination = deleteOnTermination;
        this.volumeType = volumeType;
        this.iops = iops;
        this.encrypted = encrypted;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getVirtualName() {
        return this.virtualName;
    }

    public String getEbsSnapshotId() {
        return this.snapshotId;
    }

    public Integer getEbsVolumeSize() {
        return this.sizeInGib;
    }

    public Boolean getEbsNoDevice() {
        return this.noDevice;
    }

    public Boolean getEbsDeleteOnTermination() {
        return this.deleteOnTermination;
    }

    public String getEbsVolumeType() {
        return this.volumeType;
    }

    public Integer getEbsIops() {
        return this.iops;
    }

    public Boolean getEbsEncrypted() {
        return this.encrypted;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.deleteOnTermination == null ? 0 : this.deleteOnTermination.hashCode());
        result = 31 * result + (this.deviceName == null ? 0 : this.deviceName.hashCode());
        result = 31 * result + (this.noDevice == null ? 0 : this.noDevice.hashCode());
        result = 31 * result + (this.sizeInGib == null ? 0 : this.sizeInGib.hashCode());
        result = 31 * result + (this.snapshotId == null ? 0 : this.snapshotId.hashCode());
        result = 31 * result + (this.virtualName == null ? 0 : this.virtualName.hashCode());
        result = 31 * result + (this.volumeType == null ? 0 : this.volumeType.hashCode());
        result = 31 * result + (this.iops == null ? 0 : this.iops.hashCode());
        result = 31 * result + (this.encrypted == null ? 0 : this.encrypted.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockDeviceMapping other = (BlockDeviceMapping)obj;
        if (this.deleteOnTermination == null ? other.deleteOnTermination != null : !this.deleteOnTermination.equals(other.deleteOnTermination)) {
            return false;
        }
        if (this.deviceName == null ? other.deviceName != null : !this.deviceName.equals(other.deviceName)) {
            return false;
        }
        if (this.noDevice == null ? other.noDevice != null : !this.noDevice.equals(other.noDevice)) {
            return false;
        }
        if (this.sizeInGib == null ? other.sizeInGib != null : !this.sizeInGib.equals(other.sizeInGib)) {
            return false;
        }
        if (this.snapshotId == null ? other.snapshotId != null : !this.snapshotId.equals(other.snapshotId)) {
            return false;
        }
        if (this.virtualName == null ? other.virtualName != null : !this.virtualName.equals(other.virtualName)) {
            return false;
        }
        if (this.volumeType == null ? other.volumeType != null : !this.volumeType.equals(other.volumeType)) {
            return false;
        }
        if (this.iops == null ? other.iops != null : !this.iops.equals(other.iops)) {
            return false;
        }
        return !(this.encrypted == null ? other.encrypted != null : !this.encrypted.equals(other.encrypted));
    }

    public String toString() {
        return "[deviceName=" + this.deviceName + ", virtualName=" + this.virtualName + ", snapshotId=" + this.snapshotId + ", sizeInGib=" + this.sizeInGib + ", noDevice=" + this.noDevice + ", deleteOnTermination=" + this.deleteOnTermination + ", volumeType=" + this.volumeType + ", iops=" + this.iops + ", encrypted=" + this.encrypted + "]";
    }

    @Override
    public int compareTo(BlockDeviceMapping arg0) {
        return this.deviceName.compareTo(arg0.deviceName);
    }

    public static class Builder {
        private String deviceName;
        private String virtualName;
        private String snapshotId;
        private Integer sizeInGib;
        private Boolean noDevice;
        private Boolean deleteOnTermination;
        private String volumeType;
        private Integer iops;
        private Boolean encrypted;

        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public Builder virtualName(String virtualName) {
            this.virtualName = virtualName;
            return this;
        }

        public Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public Builder sizeInGib(Integer sizeInGib) {
            this.sizeInGib = sizeInGib;
            return this;
        }

        public Builder noDevice(Boolean noDevice) {
            this.noDevice = noDevice;
            return this;
        }

        public Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public BlockDeviceMapping build() {
            return new BlockDeviceMapping(this.deviceName, this.virtualName, this.snapshotId, this.sizeInGib, this.noDevice, this.deleteOnTermination, this.volumeType, this.iops, this.encrypted);
        }

        public Builder clear() {
            this.deviceName = null;
            this.virtualName = null;
            this.snapshotId = null;
            this.sizeInGib = null;
            this.noDevice = null;
            this.deleteOnTermination = null;
            this.volumeType = null;
            this.iops = null;
            this.encrypted = null;
            return this;
        }
    }

    public static class MapEBSSnapshotToDevice
    extends BlockDeviceMapping {
        public MapEBSSnapshotToDevice(String deviceName, String snapshotId, @Nullable Integer sizeInGib, @Nullable Boolean deleteOnTermination, @Nullable String volumeType, @Nullable Integer iops, @Nullable Boolean encrypted) {
            super(deviceName, null, snapshotId, sizeInGib, null, deleteOnTermination, volumeType, iops, encrypted);
            Preconditions.checkNotNull((Object)Strings.emptyToNull((String)snapshotId), (Object)"snapshotId must be defined");
        }
    }

    public static class MapEphemeralDeviceToDevice
    extends BlockDeviceMapping {
        public MapEphemeralDeviceToDevice(String deviceName, String virtualName) {
            super(deviceName, virtualName, null, null, null, null, null, null, null);
            Preconditions.checkNotNull((Object)Strings.emptyToNull((String)virtualName), (Object)"virtualName must be defined");
        }
    }

    public static class MapNewVolumeToDevice
    extends BlockDeviceMapping {
        public MapNewVolumeToDevice(String deviceName, Integer sizeInGib, @Nullable Boolean deleteOnTermination, @Nullable String volumeType, @Nullable Integer iops, @Nullable Boolean encrypted) {
            super(deviceName, null, null, sizeInGib, null, deleteOnTermination, volumeType, iops, encrypted);
            Preconditions.checkNotNull((Object)sizeInGib, (Object)"sizeInGib cannot be null");
        }
    }

    public static class UnmapDeviceNamed
    extends BlockDeviceMapping {
        public UnmapDeviceNamed(String deviceName) {
            super(deviceName, null, null, null, true, null, null, null, null);
        }
    }
}

