/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.util;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import java.util.Map;
import org.jclouds.ec2.domain.Tag;

public class Tags {
    private Tags() {
    }

    public static Map<String, Map<String, String>> resourceToTagsAsMap(Iterable<Tag> tags) {
        return Maps.transformValues((Map)Multimaps.index(tags, Tags.resourceIdFunction()).asMap(), (Function)new Function<Iterable<Tag>, Map<String, String>>(){

            public Map<String, String> apply(Iterable<Tag> in) {
                return Maps.transformValues((Map)Maps.uniqueIndex(in, Tags.keyFunction()), Tags.valueFunction());
            }
        });
    }

    public static Function<Tag, String> valueFunction() {
        return ValueFunction.INSTANCE;
    }

    public static Function<Tag, String> keyFunction() {
        return KeyFunction.INSTANCE;
    }

    public static Function<Tag, String> resourceIdFunction() {
        return ResourceIdFunction.INSTANCE;
    }

    public static enum KeyFunction implements Function<Tag, String>
    {
        INSTANCE;


        public String apply(Tag in) {
            return in.getKey();
        }

        public String toString() {
            return "getKey()";
        }
    }

    public static enum ResourceIdFunction implements Function<Tag, String>
    {
        INSTANCE;


        public String apply(Tag in) {
            return in.getResourceId();
        }

        public String toString() {
            return "getResourceId()";
        }
    }

    public static enum ValueFunction implements Function<Tag, String>
    {
        INSTANCE;


        public String apply(Tag in) {
            return (String)in.getValue().or((Object)"");
        }

        public String toString() {
            return "getValue()";
        }
    }
}

