/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Date;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.domain.Tenant;

public class Token
implements Comparable<Token> {
    private final String id;
    private final Date expires;
    private final Optional<Tenant> tenant;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromToken(this);
    }

    @ConstructorProperties(value={"id", "expires", "tenant"})
    protected Token(String id, Date expires, @Nullable Optional<Tenant> tenant) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.expires = (Date)Preconditions.checkNotNull((Object)expires, (Object)"expires");
        this.tenant = tenant == null ? Optional.absent() : tenant;
    }

    public String getId() {
        return this.id;
    }

    public Date getExpires() {
        return this.expires;
    }

    public Optional<Tenant> getTenant() {
        return this.tenant;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.expires, this.tenant});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Token that = (Token)Token.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.expires, (Object)that.expires) && Objects.equal(this.tenant, that.tenant);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("expires", (Object)this.expires).add("tenant", this.tenant.orNull());
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(Token that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        return this.id.compareTo(that.id);
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected Date expires;
        protected Optional<Tenant> tenant = Optional.absent();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T expires(Date expires) {
            this.expires = expires;
            return this.self();
        }

        public T tenant(Tenant tenant) {
            this.tenant = Optional.fromNullable((Object)tenant);
            return this.self();
        }

        public Token build() {
            return new Token(this.id, this.expires, this.tenant);
        }

        public T fromToken(Token in) {
            return ((Builder)((Builder)this.id(in.getId())).expires(in.getExpires())).tenant((Tenant)in.getTenant().orNull());
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }
}

