/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.config;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.Atomics;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.net.Proxy;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.Fallback;
import org.jclouds.fallbacks.MapHttp4xxCodesToExceptions;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.internal.FilterStringsBoundToInjectorByName;
import org.jclouds.json.config.GsonModule;
import org.jclouds.location.config.LocationModule;
import org.jclouds.proxy.ProxyForURI;
import org.jclouds.reflect.Invocation;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.binders.BindToJsonPayloadWrappedWith;
import org.jclouds.rest.config.SetCaller;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.jclouds.rest.internal.TransformerForRequest;

public class RestModule
extends AbstractModule {
    public static final TypeLiteral<Supplier<URI>> URI_SUPPLIER_TYPE = new TypeLiteral<Supplier<URI>>(){};
    protected final AtomicReference<AuthorizationException> authException = Atomics.newReference();

    protected void installLocations() {
        this.install((Module)new LocationModule());
    }

    protected void configure() {
        this.install((Module)new SaxParserModule());
        this.install((Module)new GsonModule());
        this.install((Module)new SetCaller.Module());
        this.install(new FactoryModuleBuilder().build(BindToJsonPayloadWrappedWith.Factory.class));
        this.bind(new TypeLiteral<Function<HttpRequest, Function<HttpResponse, ?>>>(){}).to(TransformerForRequest.class);
        this.bind((TypeLiteral)new TypeLiteral<Fallback<Object>>(){}).to(MapHttp4xxCodesToExceptions.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Invocation, HttpRequest>>(){}).to(RestAnnotationProcessor.class);
        this.bind(IdentityFunction.class).toInstance((Object)IdentityFunction.INSTANCE);
        this.bind((TypeLiteral)new TypeLiteral<AtomicReference<AuthorizationException>>(){}).toInstance(this.authException);
        this.bind((TypeLiteral)new TypeLiteral<Function<Predicate<String>, Map<String, String>>>(){}).to(FilterStringsBoundToInjectorByName.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<URI, Proxy>>(){}).to(ProxyForURI.class);
        this.installLocations();
    }
}

