/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.docker.DockerApi;
import org.jclouds.docker.compute.config.DockerComputeServiceContextModule;
import org.jclouds.docker.config.DockerHttpApiModule;
import org.jclouds.docker.config.DockerParserModule;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.BaseHttpApiMetadata;

public class DockerApiMetadata
extends BaseHttpApiMetadata<DockerApi> {
    public Builder toBuilder() {
        return new Builder().fromApiMetadata((ApiMetadata)this);
    }

    public DockerApiMetadata() {
        this(new Builder());
    }

    protected DockerApiMetadata(Builder builder) {
        super((BaseHttpApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseHttpApiMetadata.defaultProperties();
        properties.setProperty("jclouds.max-retries", "15");
        properties.setProperty("jclouds.ssh.retry-auth", "true");
        properties.setProperty("jclouds.connection-timeout", "1200000");
        properties.setProperty("jclouds.image.login-user", "root:password");
        properties.setProperty("jclouds.template", "osFamily=UBUNTU,os64Bit=true,osVersionMatches=1[012].[01][04]");
        return properties;
    }

    public static class Builder
    extends BaseHttpApiMetadata.Builder<DockerApi, Builder> {
        protected Builder() {
            super(DockerApi.class);
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("docker")).name("Docker API")).identityName("user")).credentialName("password")).documentation(URI.create("https://docs.docker.com/reference/api/docker_remote_api/"))).version("1.12")).defaultEndpoint("http://127.0.0.1:2375")).defaultProperties(DockerApiMetadata.defaultProperties())).view(Reflection2.typeToken(ComputeServiceContext.class))).defaultModules((Set)ImmutableSet.of(DockerHttpApiModule.class, DockerParserModule.class, DockerComputeServiceContextModule.class));
        }

        public DockerApiMetadata build() {
            return new DockerApiMetadata(this);
        }

        protected Builder self() {
            return this;
        }

        public Builder fromApiMetadata(ApiMetadata in) {
            return this;
        }
    }
}

