/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;

public class ExposedPorts {
    @SerializedName(value="PortAndProtocol")
    private final String portAndProtocol;
    @SerializedName(value="HostPorts")
    private final Set<String> hostPorts;

    @ConstructorProperties(value={"PortAndProtocol", "HostPorts"})
    protected ExposedPorts(String portAndProtocol, @Nullable Set<String> hostPorts) {
        this.portAndProtocol = (String)Preconditions.checkNotNull((Object)portAndProtocol, (Object)"portAndProtocol");
        this.hostPorts = hostPorts != null ? ImmutableSet.copyOf(hostPorts) : ImmutableSet.of();
    }

    public String getPortAndProtocol() {
        return this.portAndProtocol;
    }

    public Set<String> getHostPorts() {
        return this.hostPorts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExposedPorts that = (ExposedPorts)o;
        return Objects.equal((Object)this.portAndProtocol, (Object)that.portAndProtocol) && Objects.equal(this.hostPorts, that.hostPorts);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.portAndProtocol, this.hostPorts});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("portAndProtocol", (Object)this.portAndProtocol).add("hostPorts", this.hostPorts).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ExposedPorts.builder().fromExposedPorts(this);
    }

    public static final class Builder {
        private String portAndProtocol;
        private Set<String> hostPorts = ImmutableSet.of();

        public Builder portAndProtocol(String portAndProtocol) {
            this.portAndProtocol = portAndProtocol;
            return this;
        }

        public Builder hostPorts(Set<String> hostPorts) {
            this.hostPorts = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(hostPorts, (Object)"hostPorts")));
            return this;
        }

        public ExposedPorts build() {
            return new ExposedPorts(this.portAndProtocol, this.hostPorts);
        }

        public Builder fromExposedPorts(ExposedPorts in) {
            return this.portAndProtocol(in.getPortAndProtocol()).hostPorts(in.getHostPorts());
        }
    }
}

