/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;

public class Image {
    @SerializedName(value="Id")
    private final String id;
    @SerializedName(value="Parent")
    private final String parent;
    @SerializedName(value="Created")
    private final String created;
    @SerializedName(value="Container")
    private final String container;
    @SerializedName(value="DockerVersion")
    private final String dockerVersion;
    @SerializedName(value="Architecture")
    private final String architecture;
    @SerializedName(value="Os")
    private final String os;
    @SerializedName(value="Size")
    private final long size;
    @SerializedName(value="VirtualSize")
    private final long virtualSize;
    @SerializedName(value="RepoTags")
    private final List<String> repoTags;

    @ConstructorProperties(value={"Id", "Parent", "Created", "Container", "DockerVersion", "Architecture", "Os", "Size", "VirtualSize", "RepoTags", "Architecture"})
    protected Image(String id, @Nullable String parent, @Nullable String created, @Nullable String container, @Nullable String dockerVersion, @Nullable String architecture, @Nullable String os, long size, @Nullable long virtualSize, @Nullable List<String> repoTags) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.parent = parent;
        this.created = created;
        this.container = container;
        this.dockerVersion = dockerVersion;
        this.architecture = architecture;
        this.os = os;
        this.size = size;
        this.virtualSize = virtualSize;
        this.repoTags = repoTags != null ? ImmutableList.copyOf(repoTags) : ImmutableList.of();
    }

    public String getId() {
        return this.id;
    }

    public String getParent() {
        return this.parent;
    }

    public String getCreated() {
        return this.created;
    }

    public String getContainer() {
        return this.container;
    }

    public String getDockerVersion() {
        return this.dockerVersion;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getOs() {
        return this.os;
    }

    public long getSize() {
        return this.size;
    }

    public long getVirtualSize() {
        return this.virtualSize;
    }

    public List<String> getRepoTags() {
        return this.repoTags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Image that = (Image)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.parent, (Object)that.parent) && Objects.equal((Object)this.created, (Object)that.created) && Objects.equal((Object)this.container, (Object)that.container) && Objects.equal((Object)this.dockerVersion, (Object)that.dockerVersion) && Objects.equal((Object)this.architecture, (Object)that.architecture) && Objects.equal((Object)this.os, (Object)that.os) && Objects.equal((Object)this.size, (Object)that.size) && Objects.equal((Object)this.virtualSize, (Object)that.virtualSize);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.parent, this.created, this.container, this.dockerVersion, this.architecture, this.os, this.size, this.virtualSize});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("parent", (Object)this.parent).add("created", (Object)this.created).add("container", (Object)this.container).add("dockerVersion", (Object)this.dockerVersion).add("architecture", (Object)this.architecture).add("os", (Object)this.os).add("size", this.size).add("virtualSize", this.virtualSize).add("repoTags", this.repoTags).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Image.builder().fromImage(this);
    }

    public static final class Builder {
        private String id;
        private String parent;
        private String created;
        private String container;
        private String dockerVersion;
        private String architecture;
        private String os;
        private long size;
        private long virtualSize;
        private List<String> repoTags = ImmutableList.of();

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder parent(String parent) {
            this.parent = parent;
            return this;
        }

        public Builder created(String created) {
            this.created = created;
            return this;
        }

        public Builder container(String container) {
            this.container = container;
            return this;
        }

        public Builder dockerVersion(String dockerVersion) {
            this.dockerVersion = dockerVersion;
            return this;
        }

        public Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public Builder os(String os) {
            this.os = os;
            return this;
        }

        public Builder size(long size) {
            this.size = size;
            return this;
        }

        public Builder virtualSize(long virtualSize) {
            this.virtualSize = virtualSize;
            return this;
        }

        public Builder repoTags(List<String> repoTags) {
            this.repoTags = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(repoTags, (Object)"repoTags")));
            return this;
        }

        public Image build() {
            return new Image(this.id, this.parent, this.created, this.container, this.dockerVersion, this.architecture, this.os, this.size, this.virtualSize, this.repoTags);
        }

        public Builder fromImage(Image in) {
            return this.id(in.getId()).parent(in.getParent()).created(in.getCreated()).container(in.getContainer()).dockerVersion(in.getDockerVersion()).architecture(in.getArchitecture()).os(in.getOs()).size(in.getSize()).virtualSize(in.getVirtualSize());
        }
    }
}

