/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.extensions;

import com.google.common.annotations.Beta;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.neutron.v2.domain.Router;
import org.jclouds.openstack.neutron.v2.domain.RouterInterface;
import org.jclouds.openstack.neutron.v2.domain.Routers;
import org.jclouds.openstack.neutron.v2.fallbacks.EmptyRoutersFallback;
import org.jclouds.openstack.neutron.v2.functions.ParseRouters;
import org.jclouds.openstack.neutron.v2.functions.RouterToPagedIterable;
import org.jclouds.openstack.neutron.v2.options.EmptyOptions;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.WrapWith;

@Path(value="/v2.0/routers")
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Beta
public interface RouterApi {
    @Named(value="router:list")
    @GET
    @Transform(value=RouterToPagedIterable.class)
    @ResponseParser(value=ParseRouters.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Router> list();

    @Named(value="router:list")
    @GET
    @ResponseParser(value=ParseRouters.class)
    @Fallback(value=EmptyRoutersFallback.class)
    public Routers list(PaginationOptions var1);

    @Named(value="router:get")
    @GET
    @Path(value="/{id}")
    @SelectJson(value={"router"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Router get(@PathParam(value="id") String var1);

    @Named(value="router:create")
    @POST
    @SelectJson(value={"router"})
    public Router create(@WrapWith(value="router") Router.CreateOptions var1);

    @Named(value="router:update")
    @PUT
    @Path(value="/{id}")
    @SelectJson(value={"router"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Router update(@PathParam(value="id") String var1, @WrapWith(value="router") Router.UpdateOptions var2);

    @Named(value="router:delete")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="id") String var1);

    @Named(value="router:addInterfaceForSubnet")
    @PUT
    @Path(value="/{id}/add_router_interface")
    @MapBinder(value=EmptyOptions.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public RouterInterface addInterfaceForSubnet(@PathParam(value="id") String var1, @PayloadParam(value="subnet_id") String var2);

    @Named(value="router:addInterfaceForPort")
    @PUT
    @Path(value="/{id}/add_router_interface")
    @MapBinder(value=EmptyOptions.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public RouterInterface addInterfaceForPort(@PathParam(value="id") String var1, @PayloadParam(value="port_id") String var2);

    @Named(value="router:removeInterfaceForSubnet")
    @PUT
    @Path(value="/{id}/remove_router_interface")
    @MapBinder(value=EmptyOptions.class)
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean removeInterfaceForSubnet(@PathParam(value="id") String var1, @PayloadParam(value="subnet_id") String var2);

    @Named(value="router:removeInterfaceForPort")
    @PUT
    @Path(value="/{id}/remove_router_interface")
    @MapBinder(value=EmptyOptions.class)
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean removeInterfaceForPort(@PathParam(value="id") String var1, @PayloadParam(value="port_id") String var2);
}

