/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2_0.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.openstack.neutron.v2_0.domain.BulkPort;
import org.jclouds.openstack.neutron.v2_0.domain.IP;
import org.jclouds.openstack.neutron.v2_0.options.CreatePortOptions;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class CreatePortBulkOptions
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;
    private final List<BulkPort> ports;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromCreatePortBulkOptions(this);
    }

    protected CreatePortBulkOptions() {
        this.ports = Lists.newArrayList();
    }

    public CreatePortBulkOptions(List<BulkPort> ports) {
        this.ports = ports;
    }

    public List<BulkPort> getPorts() {
        return this.ports;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        ArrayList createPortRequests = Lists.newArrayList();
        for (BulkPort port : this.ports) {
            CreatePortOptions.CreatePortRequest createPortRequest = new CreatePortOptions.CreatePortRequest((String)Preconditions.checkNotNull((Object)port.getNetworkId(), (Object)"network id parameter not present"));
            if (port.getName() != null) {
                createPortRequest.name = port.getName();
            }
            if (port.getAdminStateUp() != null) {
                createPortRequest.admin_state_up = port.getAdminStateUp();
            }
            if (port.getDeviceId() != null) {
                createPortRequest.device_id = port.getDeviceId();
            }
            if (port.getDeviceOwner() != null) {
                createPortRequest.device_owner = port.getDeviceOwner();
            }
            if (port.getMacAddress() != null) {
                createPortRequest.mac_address = port.getMacAddress();
            }
            if (!port.getFixedIps().isEmpty()) {
                createPortRequest.fixed_ips = Sets.newHashSet();
                for (IP fixedIp : port.getFixedIps()) {
                    CreatePortOptions.CreatePortRequest.IP requestIp = new CreatePortOptions.CreatePortRequest.IP();
                    requestIp.subnet_id = fixedIp.getSubnetId();
                    requestIp.ip_address = fixedIp.getIpAddress();
                    createPortRequest.fixed_ips.add(requestIp);
                }
            }
            createPortRequests.add(createPortRequest);
        }
        return this.bindToRequest(request, ImmutableMap.of((Object)"ports", (Object)createPortRequests));
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        return (R)this.jsonBinder.bindToRequest(request, input);
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected List<BulkPort> ports;

        protected abstract T self();

        public T ports(Collection<BulkPort> ports) {
            this.ports = ImmutableList.copyOf(ports);
            return this.self();
        }

        public CreatePortBulkOptions build() {
            return new CreatePortBulkOptions(this.ports);
        }

        public T fromCreatePortBulkOptions(CreatePortBulkOptions in) {
            return this.ports(in.getPorts());
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }
}

