/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2_0.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.openstack.neutron.v2_0.domain.BulkSubnet;
import org.jclouds.openstack.neutron.v2_0.domain.HostRoute;
import org.jclouds.openstack.neutron.v2_0.options.CreateSubnetOptions;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class CreateSubnetBulkOptions
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;
    private final List<BulkSubnet> subnets;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromCreateSubnetBulkOptions(this);
    }

    protected CreateSubnetBulkOptions() {
        this.subnets = Lists.newArrayList();
    }

    public CreateSubnetBulkOptions(List<BulkSubnet> subnets) {
        this.subnets = subnets != null ? ImmutableList.copyOf(subnets) : Lists.newArrayList();
    }

    public List<BulkSubnet> getSubnets() {
        return this.subnets;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        ArrayList createSubnetRequests = Lists.newArrayList();
        for (BulkSubnet subnet : this.subnets) {
            CreateSubnetOptions.CreateSubnetRequest createSubnetRequest = new CreateSubnetOptions.CreateSubnetRequest((String)Preconditions.checkNotNull((Object)subnet.getNetworkId(), (Object)"network id parameter not present"), (Integer)Preconditions.checkNotNull((Object)subnet.getIpVersion(), (Object)"ip version parameter not present"), (String)Preconditions.checkNotNull((Object)subnet.getCidr(), (Object)"cidr parameter not present"));
            if (subnet.getName() != null) {
                createSubnetRequest.name = subnet.getName();
            }
            if (!subnet.getAllocationPools().isEmpty()) {
                createSubnetRequest.allocation_pools = subnet.getAllocationPools();
            }
            if (subnet.getGatewayIp() != null) {
                createSubnetRequest.gateway_ip = subnet.getGatewayIp();
            }
            if (subnet.getEnableDhcp() != null) {
                createSubnetRequest.enable_dhcp = subnet.getEnableDhcp();
            }
            if (!subnet.getDnsNameServers().isEmpty()) {
                createSubnetRequest.dns_nameservers = subnet.getDnsNameServers();
            }
            if (!subnet.getHostRoutes().isEmpty()) {
                createSubnetRequest.host_routes = Sets.newHashSet();
                for (HostRoute hostRoute : subnet.getHostRoutes()) {
                    CreateSubnetOptions.CreateSubnetRequest.HostRoute requestHostRoute = new CreateSubnetOptions.CreateSubnetRequest.HostRoute();
                    requestHostRoute.destination = hostRoute.getDestinationCidr();
                    requestHostRoute.nexthop = hostRoute.getNextHop();
                    createSubnetRequest.host_routes.add(requestHostRoute);
                }
            }
            createSubnetRequests.add(createSubnetRequest);
        }
        return this.bindToRequest(request, ImmutableMap.of((Object)"subnets", (Object)createSubnetRequests));
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        return (R)this.jsonBinder.bindToRequest(request, input);
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected List<BulkSubnet> subnets;

        protected abstract T self();

        public T subnets(Collection<BulkSubnet> subnets) {
            this.subnets = ImmutableList.copyOf(subnets);
            return this.self();
        }

        public CreateSubnetBulkOptions build() {
            return new CreateSubnetBulkOptions(this.subnets);
        }

        public T fromCreateSubnetBulkOptions(CreateSubnetBulkOptions in) {
            return this.subnets(in.getSubnets());
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }
}

