/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2_0.options;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.openstack.neutron.v2_0.domain.IP;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class UpdatePortOptions
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;
    private final String name;
    private final Boolean adminStateUp;
    private final String deviceId;
    private final String deviceOwner;
    private final Set<IP> fixedIps;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromUpdatePortOptions(this);
    }

    protected UpdatePortOptions() {
        this.name = null;
        this.adminStateUp = null;
        this.deviceId = null;
        this.deviceOwner = null;
        this.fixedIps = Sets.newHashSet();
    }

    public UpdatePortOptions(String name, Boolean adminStateUp, String deviceId, String deviceOwner, Set<IP> fixedIps) {
        this.name = name;
        this.adminStateUp = adminStateUp;
        this.deviceId = deviceId;
        this.deviceOwner = deviceOwner;
        this.fixedIps = fixedIps != null ? ImmutableSet.copyOf(fixedIps) : Sets.newHashSet();
    }

    public String getName() {
        return this.name;
    }

    public Boolean getAdminStateUp() {
        return this.adminStateUp;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getDeviceOwner() {
        return this.deviceOwner;
    }

    public Set<IP> getFixedIps() {
        return this.fixedIps;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        UpdatePortRequest updatePortRequest = new UpdatePortRequest();
        if (this.name != null) {
            updatePortRequest.name = this.name;
        }
        if (this.adminStateUp != null) {
            updatePortRequest.admin_state_up = this.adminStateUp;
        }
        if (this.deviceId != null) {
            updatePortRequest.device_id = this.deviceId;
        }
        if (this.deviceOwner != null) {
            updatePortRequest.device_owner = this.deviceOwner;
        }
        if (!this.fixedIps.isEmpty()) {
            updatePortRequest.fixed_ips = Sets.newHashSet();
            for (IP fixedIp : this.fixedIps) {
                UpdatePortRequest.IP requestIp = new UpdatePortRequest.IP();
                requestIp.ip_address = fixedIp.getIpAddress();
                requestIp.subnet_id = fixedIp.getSubnetId();
                updatePortRequest.fixed_ips.add(requestIp);
            }
        }
        return this.bindToRequest(request, ImmutableMap.of((Object)"port", (Object)updatePortRequest));
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        return (R)this.jsonBinder.bindToRequest(request, input);
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String name;
        protected Boolean adminStateUp;
        protected String deviceId;
        protected String deviceOwner;
        protected Set<IP> fixedIps;

        protected abstract T self();

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T adminStateUp(Boolean adminStateUp) {
            this.adminStateUp = adminStateUp;
            return this.self();
        }

        public T deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this.self();
        }

        public T deviceOwner(String deviceOwner) {
            this.deviceOwner = deviceOwner;
            return this.self();
        }

        public T fixedIps(Collection<IP> fixedIps) {
            this.fixedIps = ImmutableSet.copyOf(fixedIps);
            return this.self();
        }

        public UpdatePortOptions build() {
            return new UpdatePortOptions(this.name, this.adminStateUp, this.deviceId, this.deviceOwner, this.fixedIps);
        }

        public T fromUpdatePortOptions(UpdatePortOptions options) {
            return ((Builder)((Builder)((Builder)((Builder)this.name(options.getName())).adminStateUp(options.getAdminStateUp())).deviceId(options.getDeviceId())).deviceOwner(options.getDeviceOwner())).fixedIps(options.getFixedIps());
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    private static class UpdatePortRequest {
        protected String name;
        protected Boolean admin_state_up;
        protected String device_id;
        protected String device_owner;
        protected Set<IP> fixed_ips;

        private UpdatePortRequest() {
        }

        private static class IP {
            protected String ip_address;
            protected String subnet_id;

            private IP() {
            }
        }
    }
}

