/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.FieldValueHitQueue;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.util.PriorityQueue;

public abstract class TopFieldCollector
extends TopDocsCollector<FieldValueHitQueue.Entry> {
    private static final ScoreDoc[] EMPTY_SCOREDOCS = new ScoreDoc[0];
    private final boolean fillFields;
    float maxScore = Float.NaN;
    final int numHits;
    FieldValueHitQueue.Entry bottom = null;
    boolean queueFull;
    int docBase;
    final boolean needsScores;

    private TopFieldCollector(PriorityQueue<FieldValueHitQueue.Entry> pq, int numHits, boolean fillFields, boolean needsScores) {
        super(pq);
        this.needsScores = needsScores;
        this.numHits = numHits;
        this.fillFields = fillFields;
    }

    @Override
    public boolean needsScores() {
        return this.needsScores;
    }

    public static TopFieldCollector create(Sort sort, int numHits, boolean fillFields, boolean trackDocScores, boolean trackMaxScore) throws IOException {
        return TopFieldCollector.create(sort, numHits, null, fillFields, trackDocScores, trackMaxScore);
    }

    public static TopFieldCollector create(Sort sort, int numHits, FieldDoc after, boolean fillFields, boolean trackDocScores, boolean trackMaxScore) throws IOException {
        if (sort.fields.length == 0) {
            throw new IllegalArgumentException("Sort must contain at least one field");
        }
        if (numHits <= 0) {
            throw new IllegalArgumentException("numHits must be > 0; please use TotalHitCountCollector if you just need the total hit count");
        }
        FieldValueHitQueue<FieldValueHitQueue.Entry> queue = FieldValueHitQueue.create(sort.fields, numHits);
        if (after == null) {
            if (trackMaxScore) {
                return new ScoringMaxScoreCollector(sort, queue, numHits, fillFields);
            }
            if (trackDocScores) {
                return new ScoringNoMaxScoreCollector(sort, queue, numHits, fillFields);
            }
            return new NonScoringCollector(sort, queue, numHits, fillFields);
        }
        if (after.fields == null) {
            throw new IllegalArgumentException("after.fields wasn't set; you must pass fillFields=true for the previous search");
        }
        if (after.fields.length != sort.getSort().length) {
            throw new IllegalArgumentException("after.fields has " + after.fields.length + " values but sort has " + sort.getSort().length);
        }
        return new PagingFieldCollector(sort, queue, after, numHits, fillFields, trackDocScores, trackMaxScore);
    }

    final void add(int slot, int doc, float score) {
        this.bottom = this.pq.add(new FieldValueHitQueue.Entry(slot, this.docBase + doc, score));
        this.queueFull = this.totalHits == this.numHits;
    }

    final void updateBottom(int doc) {
        this.bottom.doc = this.docBase + doc;
        this.bottom = (FieldValueHitQueue.Entry)this.pq.updateTop();
    }

    final void updateBottom(int doc, float score) {
        this.bottom.doc = this.docBase + doc;
        this.bottom.score = score;
        this.bottom = (FieldValueHitQueue.Entry)this.pq.updateTop();
    }

    @Override
    protected void populateResults(ScoreDoc[] results, int howMany) {
        if (this.fillFields) {
            FieldValueHitQueue queue = (FieldValueHitQueue)this.pq;
            for (int i = howMany - 1; i >= 0; --i) {
                results[i] = queue.fillFields((FieldValueHitQueue.Entry)queue.pop());
            }
        } else {
            for (int i = howMany - 1; i >= 0; --i) {
                FieldValueHitQueue.Entry entry = (FieldValueHitQueue.Entry)this.pq.pop();
                results[i] = new FieldDoc(entry.doc, entry.score);
            }
        }
    }

    @Override
    protected TopDocs newTopDocs(ScoreDoc[] results, int start) {
        if (results == null) {
            results = EMPTY_SCOREDOCS;
            this.maxScore = Float.NaN;
        }
        return new TopFieldDocs(this.totalHits, results, ((FieldValueHitQueue)this.pq).getFields(), this.maxScore);
    }

    @Override
    public TopFieldDocs topDocs() {
        return (TopFieldDocs)super.topDocs();
    }

    private static abstract class MultiComparatorLeafCollector
    implements LeafCollector {
        final LeafFieldComparator[] comparators;
        final int[] reverseMul;
        final LeafFieldComparator firstComparator;
        final int firstReverseMul;
        Scorer scorer;

        MultiComparatorLeafCollector(LeafFieldComparator[] comparators, int[] reverseMul) {
            this.comparators = comparators;
            this.reverseMul = reverseMul;
            this.firstComparator = comparators[0];
            this.firstReverseMul = reverseMul[0];
        }

        protected final int compareBottom(int doc) throws IOException {
            int cmp = this.firstReverseMul * this.firstComparator.compareBottom(doc);
            if (cmp != 0) {
                return cmp;
            }
            for (int i = 1; i < this.comparators.length; ++i) {
                cmp = this.reverseMul[i] * this.comparators[i].compareBottom(doc);
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }

        protected final void copy(int slot, int doc) throws IOException {
            for (LeafFieldComparator comparator : this.comparators) {
                comparator.copy(slot, doc);
            }
        }

        protected final void setBottom(int slot) {
            for (LeafFieldComparator comparator : this.comparators) {
                comparator.setBottom(slot);
            }
        }

        protected final int compareTop(int doc) throws IOException {
            int cmp = this.firstReverseMul * this.firstComparator.compareTop(doc);
            if (cmp != 0) {
                return cmp;
            }
            for (int i = 1; i < this.comparators.length; ++i) {
                cmp = this.reverseMul[i] * this.comparators[i].compareTop(doc);
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
            for (LeafFieldComparator comparator : this.comparators) {
                comparator.setScorer(scorer);
            }
        }
    }

    private static class NonScoringCollector
    extends TopFieldCollector {
        final FieldValueHitQueue<FieldValueHitQueue.Entry> queue;

        public NonScoringCollector(Sort sort, FieldValueHitQueue<FieldValueHitQueue.Entry> queue, int numHits, boolean fillFields) {
            super(queue, numHits, fillFields, sort.needsScores());
            this.queue = queue;
        }

        @Override
        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            this.docBase = context.docBase;
            LeafFieldComparator[] comparators = this.queue.getComparators(context);
            int[] reverseMul = this.queue.getReverseMul();
            if (comparators.length == 1) {
                return new OneComparatorLeafCollector(comparators[0], reverseMul[0]){

                    @Override
                    public void collect(int doc) throws IOException {
                        ++NonScoringCollector.this.totalHits;
                        if (NonScoringCollector.this.queueFull) {
                            if (this.reverseMul * this.comparator.compareBottom(doc) <= 0) {
                                return;
                            }
                            this.comparator.copy(NonScoringCollector.this.bottom.slot, doc);
                            NonScoringCollector.this.updateBottom(doc);
                            this.comparator.setBottom(NonScoringCollector.this.bottom.slot);
                        } else {
                            int slot = NonScoringCollector.this.totalHits - 1;
                            this.comparator.copy(slot, doc);
                            NonScoringCollector.this.add(slot, doc, Float.NaN);
                            if (NonScoringCollector.this.queueFull) {
                                this.comparator.setBottom(NonScoringCollector.this.bottom.slot);
                            }
                        }
                    }
                };
            }
            return new MultiComparatorLeafCollector(comparators, reverseMul){

                @Override
                public void collect(int doc) throws IOException {
                    ++NonScoringCollector.this.totalHits;
                    if (NonScoringCollector.this.queueFull) {
                        if (this.compareBottom(doc) <= 0) {
                            return;
                        }
                        this.copy(NonScoringCollector.this.bottom.slot, doc);
                        NonScoringCollector.this.updateBottom(doc);
                        this.setBottom(NonScoringCollector.this.bottom.slot);
                    } else {
                        int slot = NonScoringCollector.this.totalHits - 1;
                        this.copy(slot, doc);
                        NonScoringCollector.this.add(slot, doc, Float.NaN);
                        if (NonScoringCollector.this.queueFull) {
                            this.setBottom(NonScoringCollector.this.bottom.slot);
                        }
                    }
                }
            };
        }
    }

    private static abstract class OneComparatorLeafCollector
    implements LeafCollector {
        final LeafFieldComparator comparator;
        final int reverseMul;
        Scorer scorer;

        OneComparatorLeafCollector(LeafFieldComparator comparator, int reverseMul) {
            this.comparator = comparator;
            this.reverseMul = reverseMul;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
            this.comparator.setScorer(scorer);
        }
    }

    private static final class PagingFieldCollector
    extends TopFieldCollector {
        int collectedHits;
        final FieldValueHitQueue<FieldValueHitQueue.Entry> queue;
        final boolean trackDocScores;
        final boolean trackMaxScore;
        final FieldDoc after;

        public PagingFieldCollector(Sort sort, FieldValueHitQueue<FieldValueHitQueue.Entry> queue, FieldDoc after, int numHits, boolean fillFields, boolean trackDocScores, boolean trackMaxScore) {
            super(queue, numHits, fillFields, trackDocScores || trackMaxScore || sort.needsScores());
            this.queue = queue;
            this.trackDocScores = trackDocScores;
            this.trackMaxScore = trackMaxScore;
            this.after = after;
            this.maxScore = Float.NEGATIVE_INFINITY;
            FieldComparator<?>[] comparators = queue.comparators;
            for (int i = 0; i < comparators.length; ++i) {
                FieldComparator<?> comparator = comparators[i];
                comparator.setTopValue(after.fields[i]);
            }
        }

        @Override
        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            this.docBase = context.docBase;
            final int afterDoc = this.after.doc - this.docBase;
            return new MultiComparatorLeafCollector(this.queue.getComparators(context), this.queue.getReverseMul()){

                @Override
                public void collect(int doc) throws IOException {
                    int cmp;
                    ++PagingFieldCollector.this.totalHits;
                    float score = Float.NaN;
                    if (PagingFieldCollector.this.trackMaxScore && (score = this.scorer.score()) > PagingFieldCollector.this.maxScore) {
                        PagingFieldCollector.this.maxScore = score;
                    }
                    if (PagingFieldCollector.this.queueFull && (cmp = this.compareBottom(doc)) <= 0) {
                        return;
                    }
                    int topCmp = this.compareTop(doc);
                    if (topCmp > 0 || topCmp == 0 && doc <= afterDoc) {
                        return;
                    }
                    if (PagingFieldCollector.this.queueFull) {
                        this.copy(PagingFieldCollector.this.bottom.slot, doc);
                        if (PagingFieldCollector.this.trackDocScores && !PagingFieldCollector.this.trackMaxScore) {
                            score = this.scorer.score();
                        }
                        PagingFieldCollector.this.updateBottom(doc, score);
                        this.setBottom(PagingFieldCollector.this.bottom.slot);
                    } else {
                        ++PagingFieldCollector.this.collectedHits;
                        int slot = PagingFieldCollector.this.collectedHits - 1;
                        this.copy(slot, doc);
                        if (PagingFieldCollector.this.trackDocScores && !PagingFieldCollector.this.trackMaxScore) {
                            score = this.scorer.score();
                        }
                        PagingFieldCollector.this.bottom = PagingFieldCollector.this.pq.add(new FieldValueHitQueue.Entry(slot, PagingFieldCollector.this.docBase + doc, score));
                        boolean bl = PagingFieldCollector.this.queueFull = PagingFieldCollector.this.collectedHits == PagingFieldCollector.this.numHits;
                        if (PagingFieldCollector.this.queueFull) {
                            this.setBottom(PagingFieldCollector.this.bottom.slot);
                        }
                    }
                }
            };
        }
    }

    private static class ScoringMaxScoreCollector
    extends TopFieldCollector {
        final FieldValueHitQueue<FieldValueHitQueue.Entry> queue;

        public ScoringMaxScoreCollector(Sort sort, FieldValueHitQueue<FieldValueHitQueue.Entry> queue, int numHits, boolean fillFields) {
            super(queue, numHits, fillFields, true);
            this.queue = queue;
            this.maxScore = Float.MIN_NORMAL;
        }

        @Override
        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            this.docBase = context.docBase;
            LeafFieldComparator[] comparators = this.queue.getComparators(context);
            int[] reverseMul = this.queue.getReverseMul();
            if (comparators.length == 1) {
                return new OneComparatorLeafCollector(comparators[0], reverseMul[0]){

                    @Override
                    public void collect(int doc) throws IOException {
                        float score = this.scorer.score();
                        if (score > ScoringMaxScoreCollector.this.maxScore) {
                            ScoringMaxScoreCollector.this.maxScore = score;
                        }
                        ++ScoringMaxScoreCollector.this.totalHits;
                        if (ScoringMaxScoreCollector.this.queueFull) {
                            if (this.reverseMul * this.comparator.compareBottom(doc) <= 0) {
                                return;
                            }
                            this.comparator.copy(ScoringMaxScoreCollector.this.bottom.slot, doc);
                            ScoringMaxScoreCollector.this.updateBottom(doc, score);
                            this.comparator.setBottom(ScoringMaxScoreCollector.this.bottom.slot);
                        } else {
                            int slot = ScoringMaxScoreCollector.this.totalHits - 1;
                            this.comparator.copy(slot, doc);
                            ScoringMaxScoreCollector.this.add(slot, doc, score);
                            if (ScoringMaxScoreCollector.this.queueFull) {
                                this.comparator.setBottom(ScoringMaxScoreCollector.this.bottom.slot);
                            }
                        }
                    }
                };
            }
            return new MultiComparatorLeafCollector(comparators, reverseMul){

                @Override
                public void collect(int doc) throws IOException {
                    float score = this.scorer.score();
                    if (score > ScoringMaxScoreCollector.this.maxScore) {
                        ScoringMaxScoreCollector.this.maxScore = score;
                    }
                    ++ScoringMaxScoreCollector.this.totalHits;
                    if (ScoringMaxScoreCollector.this.queueFull) {
                        if (this.compareBottom(doc) <= 0) {
                            return;
                        }
                        this.copy(ScoringMaxScoreCollector.this.bottom.slot, doc);
                        ScoringMaxScoreCollector.this.updateBottom(doc, score);
                        this.setBottom(ScoringMaxScoreCollector.this.bottom.slot);
                    } else {
                        int slot = ScoringMaxScoreCollector.this.totalHits - 1;
                        this.copy(slot, doc);
                        ScoringMaxScoreCollector.this.add(slot, doc, score);
                        if (ScoringMaxScoreCollector.this.queueFull) {
                            this.setBottom(ScoringMaxScoreCollector.this.bottom.slot);
                        }
                    }
                }
            };
        }
    }

    private static class ScoringNoMaxScoreCollector
    extends TopFieldCollector {
        final FieldValueHitQueue<FieldValueHitQueue.Entry> queue;

        public ScoringNoMaxScoreCollector(Sort sort, FieldValueHitQueue<FieldValueHitQueue.Entry> queue, int numHits, boolean fillFields) {
            super(queue, numHits, fillFields, true);
            this.queue = queue;
        }

        @Override
        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            this.docBase = context.docBase;
            LeafFieldComparator[] comparators = this.queue.getComparators(context);
            int[] reverseMul = this.queue.getReverseMul();
            if (comparators.length == 1) {
                return new OneComparatorLeafCollector(comparators[0], reverseMul[0]){

                    @Override
                    public void collect(int doc) throws IOException {
                        ++ScoringNoMaxScoreCollector.this.totalHits;
                        if (ScoringNoMaxScoreCollector.this.queueFull) {
                            if (this.reverseMul * this.comparator.compareBottom(doc) <= 0) {
                                return;
                            }
                            float score = this.scorer.score();
                            this.comparator.copy(ScoringNoMaxScoreCollector.this.bottom.slot, doc);
                            ScoringNoMaxScoreCollector.this.updateBottom(doc, score);
                            this.comparator.setBottom(ScoringNoMaxScoreCollector.this.bottom.slot);
                        } else {
                            float score = this.scorer.score();
                            int slot = ScoringNoMaxScoreCollector.this.totalHits - 1;
                            this.comparator.copy(slot, doc);
                            ScoringNoMaxScoreCollector.this.add(slot, doc, score);
                            if (ScoringNoMaxScoreCollector.this.queueFull) {
                                this.comparator.setBottom(ScoringNoMaxScoreCollector.this.bottom.slot);
                            }
                        }
                    }
                };
            }
            return new MultiComparatorLeafCollector(comparators, reverseMul){

                @Override
                public void collect(int doc) throws IOException {
                    ++ScoringNoMaxScoreCollector.this.totalHits;
                    if (ScoringNoMaxScoreCollector.this.queueFull) {
                        if (this.compareBottom(doc) <= 0) {
                            return;
                        }
                        float score = this.scorer.score();
                        this.copy(ScoringNoMaxScoreCollector.this.bottom.slot, doc);
                        ScoringNoMaxScoreCollector.this.updateBottom(doc, score);
                        this.setBottom(ScoringNoMaxScoreCollector.this.bottom.slot);
                    } else {
                        float score = this.scorer.score();
                        int slot = ScoringNoMaxScoreCollector.this.totalHits - 1;
                        this.copy(slot, doc);
                        ScoringNoMaxScoreCollector.this.add(slot, doc, score);
                        if (ScoringNoMaxScoreCollector.this.queueFull) {
                            this.setBottom(ScoringNoMaxScoreCollector.this.bottom.slot);
                        }
                    }
                }
            };
        }
    }
}

