/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.batch;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.odata2.api.batch.BatchException;
import org.apache.olingo.odata2.api.exception.MessageReference;

public class AcceptParser {
    private static final String BAD_REQUEST = "400";
    private static final String ALL = "*";
    private static final String REG_EX_QUALITY_FACTOR = "q=((?:1\\.0{0,3})|(?:0\\.[0-9]{0,2}[1-9]))";
    private static final String REG_EX_OPTIONAL_WHITESPACE = "\\s?";
    private static final Pattern REG_EX_ACCEPT = Pattern.compile("([a-z\\*]+/[a-z0-9\\+\\*\\-=;\\s]+)");
    private static final Pattern REG_EX_ACCEPT_WITH_Q_FACTOR = Pattern.compile(REG_EX_ACCEPT + "(?:;" + "\\s?" + "q=((?:1\\.0{0,3})|(?:0\\.[0-9]{0,2}[1-9]))" + ")?");
    private static final Pattern REG_EX_ACCEPT_LANGUAGES = Pattern.compile("((?:(?:[a-z]{1,8})|(?:\\*))\\-?(?:[a-zA-Z]{1,8})?)");
    private static final Pattern REG_EX_ACCEPT_LANGUAGES_WITH_Q_FACTOR = Pattern.compile(REG_EX_ACCEPT_LANGUAGES + "(?:;" + "\\s?" + "q=((?:1\\.0{0,3})|(?:0\\.[0-9]{0,2}[1-9]))" + ")?");
    private static final double QUALITY_PARAM_FACTOR = 0.001;
    private List<String> acceptHeaderValues = new ArrayList<String>();
    private List<String> acceptLanguageHeaderValues = new ArrayList<String>();

    public List<String> parseAcceptHeaders() throws BatchException {
        return this.parseQualifiedHeader(this.acceptHeaderValues, REG_EX_ACCEPT_WITH_Q_FACTOR, BatchException.INVALID_ACCEPT_HEADER);
    }

    public List<String> parseAcceptableLanguages() throws BatchException {
        return this.parseQualifiedHeader(this.acceptLanguageHeaderValues, REG_EX_ACCEPT_LANGUAGES_WITH_Q_FACTOR, BatchException.INVALID_ACCEPT_LANGUAGE_HEADER);
    }

    private List<String> parseQualifiedHeader(List<String> headerValues, Pattern regEx, MessageReference exectionMessage) throws BatchException {
        TreeSet<Accept> acceptTree = new TreeSet<Accept>();
        ArrayList<String> acceptHeaders = new ArrayList<String>();
        for (String headerValue : headerValues) {
            String[] acceptParts;
            for (String part : acceptParts = headerValue.split(",")) {
                Matcher matcher = regEx.matcher(part.trim());
                if (!matcher.matches() || matcher.groupCount() != 2) {
                    throw new BatchException(exectionMessage.addContent(part), BAD_REQUEST);
                }
                Accept acceptHeader = this.getQualifiedHeader(matcher);
                acceptTree.add(acceptHeader);
            }
        }
        for (Accept accept : acceptTree) {
            if (acceptHeaders.contains(accept.getValue())) continue;
            acceptHeaders.add(accept.getValue());
        }
        return acceptHeaders;
    }

    private Accept getQualifiedHeader(Matcher matcher) {
        String acceptHeaderValue = matcher.group(1);
        double qualityFactor = matcher.group(2) != null ? Double.parseDouble(matcher.group(2)) : 1.0;
        qualityFactor = this.getQualityFactor(acceptHeaderValue, qualityFactor);
        return new Accept().setQuality(qualityFactor).setValue(acceptHeaderValue);
    }

    private double getQualityFactor(String acceptHeaderValue, double qualityFactor) {
        int paramNumber = 0;
        double typeFactor = 0.0;
        double subtypeFactor = 0.0;
        String[] mediaRange = acceptHeaderValue.split("(?=[^;]+);");
        String[] mediaTypes = mediaRange[0].split("/");
        if (mediaTypes.length == 2) {
            String type = mediaTypes[0];
            String subtype = mediaTypes[1];
            if (!ALL.equals(type)) {
                typeFactor = 0.001;
            }
            if (!ALL.equals(subtype)) {
                subtypeFactor = 0.001;
            }
        }
        if (mediaRange.length == 2) {
            String[] parameters = mediaRange[1].split(";\\s?");
            paramNumber = parameters.length;
        }
        qualityFactor = qualityFactor + (double)paramNumber * 0.001 + typeFactor + subtypeFactor;
        return qualityFactor;
    }

    public void addAcceptHeaderValue(String headerValue) {
        this.acceptHeaderValues.add(headerValue);
    }

    public void addAcceptLanguageHeaderValue(String headerValue) {
        this.acceptLanguageHeaderValues.add(headerValue);
    }

    private static class Accept
    implements Comparable<Accept> {
        private double quality;
        private String value;

        private Accept() {
        }

        public String getValue() {
            return this.value;
        }

        public Accept setValue(String value) {
            this.value = value;
            return this;
        }

        public Accept setQuality(double quality) {
            this.quality = quality;
            return this;
        }

        @Override
        public int compareTo(Accept o) {
            if (this.quality <= o.quality) {
                return 1;
            }
            return -1;
        }
    }
}

