/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.batch.v2;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.odata2.api.batch.BatchException;
import org.apache.olingo.odata2.core.batch.AcceptParser;
import org.apache.olingo.odata2.core.batch.v2.BufferedReaderIncludingLineEndings;
import org.apache.olingo.odata2.core.batch.v2.Header;
import org.apache.olingo.odata2.core.commons.Decoder;

public class BatchParserCommon {
    private static final Pattern PATTERN_LAST_CRLF = Pattern.compile("(.*)(\r\n){1}( *)", 32);
    private static final String REG_EX_BOUNDARY = "([a-zA-Z0-9_\\-\\.'\\+]{1,70})|\"([a-zA-Z0-9_\\-\\.'\\+\\s\\(\\),/:=\\?]{1,69}[a-zA-Z0-9_\\-\\.'\\+\\(\\),/:=\\?])\"";
    public static final Pattern PATTERN_MULTIPART_MIXED = Pattern.compile("multipart/mixed(.*)", 2);
    static final String REG_EX_APPLICATION_HTTP = "application/http";
    public static final Pattern PATTERN_HEADER_LINE = Pattern.compile("([a-zA-Z\\-]+):\\s?(.*)\\s*");
    public static final Pattern PATTERN_CONTENT_TYPE_APPLICATION_HTTP = Pattern.compile("application/http", 2);
    public static final Pattern PATTERN_RELATIVE_URI = Pattern.compile("([^/][^?]*)(\\?.*)?");

    public static String trimLineListToLength(List<BufferedReaderIncludingLineEndings.Line> list, int length) {
        String message = BatchParserCommon.lineListToString(list);
        int lastIndex = Math.min(length, message.length());
        return lastIndex > 0 ? message.substring(0, lastIndex) : "";
    }

    public static String lineListToString(List<BufferedReaderIncludingLineEndings.Line> list) {
        StringBuilder builder = new StringBuilder();
        for (BufferedReaderIncludingLineEndings.Line currentLine : list) {
            builder.append(currentLine.toString());
        }
        return builder.toString();
    }

    public static InputStream convertLineListToInputStream(List<BufferedReaderIncludingLineEndings.Line> messageList, int contentLength) throws BatchException {
        String message = BatchParserCommon.trimLineListToLength(messageList, contentLength);
        return new ByteArrayInputStream(message.getBytes());
    }

    public static InputStream convertLineListToInputStream(List<BufferedReaderIncludingLineEndings.Line> messageList) throws BatchException {
        String message = BatchParserCommon.lineListToString(messageList);
        return new ByteArrayInputStream(message.getBytes());
    }

    static List<List<BufferedReaderIncludingLineEndings.Line>> splitMessageByBoundary(List<BufferedReaderIncludingLineEndings.Line> message, String boundary) throws BatchException {
        int lineNumer;
        LinkedList<List<BufferedReaderIncludingLineEndings.Line>> messageParts = new LinkedList<List<BufferedReaderIncludingLineEndings.Line>>();
        AbstractList currentPart = new ArrayList<BufferedReaderIncludingLineEndings.Line>();
        boolean isEndReached = false;
        String quotedBoundary = Pattern.quote(boundary);
        Pattern boundaryDelimiterPattern = Pattern.compile("--" + quotedBoundary + "--[\\s ]*");
        Pattern boundaryPattern = Pattern.compile("--" + quotedBoundary + "[\\s ]*");
        for (BufferedReaderIncludingLineEndings.Line currentLine : message) {
            if (boundaryDelimiterPattern.matcher(currentLine.toString()).matches()) {
                BatchParserCommon.removeEndingCRLFFromList(currentPart);
                messageParts.add(currentPart);
                isEndReached = true;
            } else if (boundaryPattern.matcher(currentLine.toString()).matches()) {
                BatchParserCommon.removeEndingCRLFFromList(currentPart);
                messageParts.add(currentPart);
                currentPart = new LinkedList();
            } else {
                currentPart.add(currentLine);
            }
            if (!isEndReached) continue;
            break;
        }
        int n = lineNumer = message.size() > 0 ? message.get(0).getLineNumber() : 0;
        if (messageParts.size() <= 0) {
            throw new BatchException(BatchException.MISSING_BOUNDARY_DELIMITER.addContent(lineNumer));
        }
        messageParts.remove(0);
        if (!isEndReached) {
            throw new BatchException(BatchException.MISSING_CLOSE_DELIMITER.addContent(lineNumer));
        }
        if (messageParts.size() == 0) {
            throw new BatchException(BatchException.NO_MATCH_WITH_BOUNDARY_STRING.addContent(boundary).addContent(lineNumer));
        }
        return messageParts;
    }

    private static void removeEndingCRLFFromList(List<BufferedReaderIncludingLineEndings.Line> list) {
        if (list.size() > 0) {
            BufferedReaderIncludingLineEndings.Line lastLine = list.remove(list.size() - 1);
            list.add(BatchParserCommon.removeEndingCRLF(lastLine));
        }
    }

    public static BufferedReaderIncludingLineEndings.Line removeEndingCRLF(BufferedReaderIncludingLineEndings.Line line) {
        Pattern pattern = PATTERN_LAST_CRLF;
        Matcher matcher = pattern.matcher(line.toString());
        if (matcher.matches()) {
            return new BufferedReaderIncludingLineEndings.Line(matcher.group(1), line.getLineNumber());
        }
        return line;
    }

    public static Header consumeHeaders(List<BufferedReaderIncludingLineEndings.Line> remainingMessage) throws BatchException {
        int headerLineNumber = remainingMessage.size() != 0 ? remainingMessage.get(0).getLineNumber() : 0;
        Header headers = new Header(headerLineNumber);
        Iterator<BufferedReaderIncludingLineEndings.Line> iter = remainingMessage.iterator();
        AcceptParser acceptParser = new AcceptParser();
        int acceptLineNumber = 0;
        int acceptLanguageLineNumber = 0;
        boolean isHeader = true;
        while (iter.hasNext() && isHeader) {
            BufferedReaderIncludingLineEndings.Line currentLine = iter.next();
            Matcher headerMatcher = PATTERN_HEADER_LINE.matcher(currentLine.toString());
            if (headerMatcher.matches() && headerMatcher.groupCount() == 2) {
                iter.remove();
                String headerName = headerMatcher.group(1).trim();
                String headerValue = headerMatcher.group(2).trim();
                if ("Accept".equalsIgnoreCase(headerName)) {
                    acceptParser.addAcceptHeaderValue(headerValue);
                    acceptLineNumber = currentLine.getLineNumber();
                    continue;
                }
                if ("Accept-Language".equalsIgnoreCase(headerName)) {
                    acceptParser.addAcceptLanguageHeaderValue(headerValue);
                    acceptLanguageLineNumber = currentLine.getLineNumber();
                    continue;
                }
                headers.addHeader(headerName, Header.splitValuesByComma(headerValue), currentLine.getLineNumber());
                continue;
            }
            isHeader = false;
        }
        headers.addHeader("Accept", acceptParser.parseAcceptHeaders(), acceptLineNumber);
        headers.addHeader("Accept-Language", acceptParser.parseAcceptableLanguages(), acceptLanguageLineNumber);
        return headers;
    }

    public static void consumeBlankLine(List<BufferedReaderIncludingLineEndings.Line> remainingMessage, boolean isStrict) throws BatchException {
        if (remainingMessage.size() > 0 && remainingMessage.get(0).toString().matches("\\s*\r\n\\s*")) {
            remainingMessage.remove(0);
        } else if (isStrict) {
            int lineNumber = remainingMessage.size() > 0 ? remainingMessage.get(0).getLineNumber() : 0;
            throw new BatchException(BatchException.MISSING_BLANK_LINE.addContent("[None]").addContent(lineNumber));
        }
    }

    public static String getBoundary(String contentType, int line) throws BatchException {
        if (contentType.toLowerCase(Locale.ENGLISH).startsWith("multipart/mixed")) {
            String[] parameter;
            for (String pair : parameter = contentType.split(";")) {
                String[] attrValue = pair.split("=");
                if (attrValue.length != 2 || !"boundary".equals(attrValue[0].trim().toLowerCase(Locale.ENGLISH))) continue;
                if (attrValue[1].matches(REG_EX_BOUNDARY)) {
                    return BatchParserCommon.trimQuota(attrValue[1].trim());
                }
                throw new BatchException(BatchException.INVALID_BOUNDARY.addContent(line));
            }
        }
        throw new BatchException(BatchException.INVALID_CONTENT_TYPE.addContent("multipart/mixed"));
    }

    private static String trimQuota(String boundary) {
        if (boundary.matches("\".*\"")) {
            boundary = boundary.replace("\"", "");
        }
        return boundary;
    }

    public static Map<String, List<String>> parseQueryParameter(BufferedReaderIncludingLineEndings.Line httpRequest) {
        String[] parts;
        HashMap<String, List<String>> queryParameter = new HashMap<String, List<String>>();
        String[] requestParts = httpRequest.toString().split(" ");
        if (requestParts.length == 3 && (parts = requestParts[1].split("\\?")).length == 2) {
            String[] parameters;
            for (String parameter : parameters = parts[1].split("&")) {
                String[] valueParts;
                String[] parameterParts = parameter.split("=");
                String parameterName = parameterParts[0].toLowerCase(Locale.ENGLISH);
                if (parameterParts.length != 2) continue;
                List valueList = (List)queryParameter.get(parameterName);
                valueList = valueList == null ? new LinkedList() : valueList;
                queryParameter.put(parameterName, valueList);
                for (String value : valueParts = parameterParts[1].split(",")) {
                    valueList.add(Decoder.decode(value));
                }
            }
        }
        return queryParameter;
    }
}

