/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.core.edm.AbstractSimpleType;

public class EdmDateTime
extends AbstractSimpleType {
    private static final Pattern PATTERN = Pattern.compile("(\\p{Digit}{1,4})-(\\p{Digit}{1,2})-(\\p{Digit}{1,2})T(\\p{Digit}{1,2}):(\\p{Digit}{1,2})(?::(\\p{Digit}{1,2})(\\.(\\p{Digit}{0,3}?)0*)?)?");
    private static final Pattern JSON_PATTERN = Pattern.compile("/Date\\((-?\\p{Digit}+)\\)/");
    private static final EdmDateTime instance = new EdmDateTime();

    public static EdmDateTime getInstance() {
        return instance;
    }

    @Override
    public Class<?> getDefaultType() {
        return Calendar.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected <T> T internalValueOfString(String value, EdmLiteralKind literalKind, EdmFacets facets, Class<T> returnType) throws EdmSimpleTypeException {
        Matcher matcher;
        if (literalKind == EdmLiteralKind.JSON && (matcher = JSON_PATTERN.matcher(value)).matches()) {
            long millis;
            try {
                millis = Long.parseLong(matcher.group(1));
            }
            catch (NumberFormatException e) {
                throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value), (Throwable)e);
            }
            if (returnType.isAssignableFrom(Long.class)) {
                return returnType.cast(millis);
            }
            if (returnType.isAssignableFrom(Date.class)) {
                return returnType.cast(new Date(millis));
            }
            if (!returnType.isAssignableFrom(Calendar.class)) throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(returnType));
            Calendar dateTimeValue = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            dateTimeValue.clear();
            dateTimeValue.setTimeInMillis(millis);
            return returnType.cast(dateTimeValue);
        }
        Calendar dateTimeValue = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        dateTimeValue.clear();
        if (literalKind == EdmLiteralKind.URI) {
            if (value.length() <= 10 || !value.startsWith("datetime'") || !value.endsWith("'")) throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value));
            EdmDateTime.parseLiteral(value.substring(9, value.length() - 1), facets, dateTimeValue);
        } else {
            EdmDateTime.parseLiteral(value, facets, dateTimeValue);
        }
        if (returnType.isAssignableFrom(Calendar.class)) {
            return returnType.cast(dateTimeValue);
        }
        if (returnType.isAssignableFrom(Long.class)) {
            return returnType.cast(dateTimeValue.getTimeInMillis());
        }
        if (!returnType.isAssignableFrom(Date.class)) throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(returnType));
        return returnType.cast(dateTimeValue.getTime());
    }

    protected static void parseLiteral(String value, EdmFacets facets, Calendar dateTimeValue) throws EdmSimpleTypeException {
        Matcher matcher = PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value));
        }
        dateTimeValue.set(Short.parseShort(matcher.group(1)), Byte.parseByte(matcher.group(2)) - 1, Byte.parseByte(matcher.group(3)), Byte.parseByte(matcher.group(4)), Byte.parseByte(matcher.group(5)), matcher.group(6) == null ? 0 : (int)Byte.parseByte(matcher.group(6)));
        if (matcher.group(7) != null) {
            if (matcher.group(7).length() == 1 || matcher.group(7).length() > 8) {
                throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value));
            }
            String decimals = matcher.group(8);
            if (facets != null && facets.getPrecision() != null && facets.getPrecision() < decimals.length()) {
                throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_FACETS_NOT_MATCHED.addContent(value, facets));
            }
            String milliSeconds = decimals + "000".substring(decimals.length());
            dateTimeValue.set(14, Short.parseShort(milliSeconds));
        }
        dateTimeValue.setLenient(false);
        try {
            dateTimeValue.get(14);
        }
        catch (IllegalArgumentException e) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value), (Throwable)e);
        }
        dateTimeValue.setLenient(true);
    }

    @Override
    protected <T> String internalValueToString(T value, EdmLiteralKind literalKind, EdmFacets facets) throws EdmSimpleTypeException {
        long timeInMillis;
        if (value instanceof Date) {
            timeInMillis = ((Date)value).getTime();
        } else if (value instanceof Calendar) {
            timeInMillis = ((Calendar)value).getTimeInMillis();
        } else if (value instanceof Long) {
            timeInMillis = (Long)value;
        } else {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(value.getClass()));
        }
        if (literalKind == EdmLiteralKind.JSON) {
            return "/Date(" + timeInMillis + ")/";
        }
        Calendar dateTimeValue = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        dateTimeValue.setTimeInMillis(timeInMillis);
        StringBuilder result = new StringBuilder(23);
        int year = dateTimeValue.get(1);
        EdmDateTime.appendTwoDigits(result, year / 100);
        EdmDateTime.appendTwoDigits(result, year % 100);
        result.append('-');
        EdmDateTime.appendTwoDigits(result, dateTimeValue.get(2) + 1);
        result.append('-');
        EdmDateTime.appendTwoDigits(result, dateTimeValue.get(5));
        result.append('T');
        EdmDateTime.appendTwoDigits(result, dateTimeValue.get(11));
        result.append(':');
        EdmDateTime.appendTwoDigits(result, dateTimeValue.get(12));
        result.append(':');
        EdmDateTime.appendTwoDigits(result, dateTimeValue.get(13));
        try {
            EdmDateTime.appendMilliseconds(result, dateTimeValue.get(14), facets);
        }
        catch (IllegalArgumentException e) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_FACETS_NOT_MATCHED.addContent(value, facets), (Throwable)e);
        }
        return result.toString();
    }

    private static void appendTwoDigits(StringBuilder result, int number) {
        result.append((char)(48 + number / 10));
        result.append((char)(48 + number % 10));
    }

    protected static void appendMilliseconds(StringBuilder result, long milliseconds, EdmFacets facets) throws IllegalArgumentException {
        int digits;
        int n = milliseconds % 1000L == 0L ? 0 : (milliseconds % 100L == 0L ? 1 : (digits = milliseconds % 10L == 0L ? 2 : 3));
        if (digits > 0) {
            result.append('.');
            for (int d = 100; d > 0; d /= 10) {
                byte digit = (byte)(milliseconds % (long)(d * 10) / (long)d);
                if (digit <= 0 && milliseconds % (long)d <= 0L) continue;
                result.append((char)(48 + digit));
            }
        }
        if (facets != null && facets.getPrecision() != null) {
            int precision = facets.getPrecision();
            if (digits > precision) {
                throw new IllegalArgumentException();
            }
            if (digits == 0 && precision > 0) {
                result.append('.');
            }
            for (int i = digits; i < precision; ++i) {
                result.append('0');
            }
        }
    }

    @Override
    public String toUriLiteral(String literal) throws EdmSimpleTypeException {
        return "datetime'" + literal + "'";
    }
}

