/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.servlet;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.olingo.odata2.api.ODataService;
import org.apache.olingo.odata2.api.ODataServiceFactory;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.commons.ODataHttpMethod;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataBadRequestException;
import org.apache.olingo.odata2.api.exception.ODataHttpException;
import org.apache.olingo.odata2.api.exception.ODataInternalServerErrorException;
import org.apache.olingo.odata2.api.exception.ODataMethodNotAllowedException;
import org.apache.olingo.odata2.api.exception.ODataNotAcceptableException;
import org.apache.olingo.odata2.api.exception.ODataNotImplementedException;
import org.apache.olingo.odata2.api.processor.ODataRequest;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.core.ODataContextImpl;
import org.apache.olingo.odata2.core.ODataRequestHandler;
import org.apache.olingo.odata2.core.exception.ODataRuntimeException;
import org.apache.olingo.odata2.core.servlet.ODataExceptionWrapper;
import org.apache.olingo.odata2.core.servlet.RestUtil;

public class ODataServlet
extends HttpServlet {
    private static final String HTTP_METHOD_OPTIONS = "OPTIONS";
    private static final String HTTP_METHOD_HEAD = "HEAD";
    private static final long serialVersionUID = 1L;

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String factoryClassName = this.getInitParameter("org.apache.olingo.odata2.service.factory");
        if (factoryClassName == null) {
            throw new ODataRuntimeException("config missing: org.apache.olingo.odata2.service.factory");
        }
        ODataServiceFactory serviceFactory = this.createServiceFactory(req);
        String xHttpMethod = req.getHeader("X-HTTP-Method");
        String xHttpMethodOverride = req.getHeader("X-HTTP-Method-Override");
        if (xHttpMethod != null && xHttpMethodOverride != null && !xHttpMethod.equalsIgnoreCase(xHttpMethodOverride)) {
            ODataExceptionWrapper wrapper = new ODataExceptionWrapper(req, serviceFactory);
            this.createResponse(resp, wrapper.wrapInExceptionResponse(new ODataBadRequestException(ODataBadRequestException.AMBIGUOUS_XMETHOD)));
        }
        if (req.getPathInfo() != null) {
            this.handle(req, resp, xHttpMethod, xHttpMethodOverride, serviceFactory);
        } else {
            this.handleRedirect(req, resp, serviceFactory);
        }
    }

    private void handle(HttpServletRequest req, HttpServletResponse resp, String xHttpMethod, String xHttpMethodOverride, ODataServiceFactory serviceFactory) throws IOException {
        String method = req.getMethod();
        if (ODataHttpMethod.GET.name().equals(method)) {
            this.handleRequest(req, ODataHttpMethod.GET, resp, serviceFactory);
        } else if (ODataHttpMethod.POST.name().equals(method)) {
            if (xHttpMethod == null && xHttpMethodOverride == null) {
                this.handleRequest(req, ODataHttpMethod.POST, resp, serviceFactory);
            } else if (xHttpMethod == null) {
                boolean methodHandled = this.handleHttpTunneling(req, resp, xHttpMethodOverride, serviceFactory);
                if (!methodHandled) {
                    this.createMethodNotAllowedResponse(req, ODataHttpException.COMMON, resp, serviceFactory);
                }
            } else {
                boolean methodHandled = this.handleHttpTunneling(req, resp, xHttpMethod, serviceFactory);
                if (!methodHandled) {
                    this.createNotImplementedResponse(req, ODataNotImplementedException.TUNNELING, resp, serviceFactory);
                }
            }
        } else if (ODataHttpMethod.PUT.name().equals(method)) {
            this.handleRequest(req, ODataHttpMethod.PUT, resp, serviceFactory);
        } else if (ODataHttpMethod.DELETE.name().equals(method)) {
            this.handleRequest(req, ODataHttpMethod.DELETE, resp, serviceFactory);
        } else if (ODataHttpMethod.PATCH.name().equals(method)) {
            this.handleRequest(req, ODataHttpMethod.PATCH, resp, serviceFactory);
        } else if (ODataHttpMethod.MERGE.name().equals(method)) {
            this.handleRequest(req, ODataHttpMethod.MERGE, resp, serviceFactory);
        } else if (HTTP_METHOD_HEAD.equals(method) || HTTP_METHOD_OPTIONS.equals(method)) {
            this.createNotImplementedResponse(req, ODataNotImplementedException.COMMON, resp, serviceFactory);
        } else {
            this.createNotImplementedResponse(req, ODataHttpException.COMMON, resp, serviceFactory);
        }
    }

    private boolean handleHttpTunneling(HttpServletRequest req, HttpServletResponse resp, String xHttpMethod, ODataServiceFactory serviceFactory) throws IOException {
        if (ODataHttpMethod.MERGE.name().equals(xHttpMethod)) {
            this.handleRequest(req, ODataHttpMethod.MERGE, resp, serviceFactory);
        } else if (ODataHttpMethod.PATCH.name().equals(xHttpMethod)) {
            this.handleRequest(req, ODataHttpMethod.PATCH, resp, serviceFactory);
        } else if (ODataHttpMethod.DELETE.name().equals(xHttpMethod)) {
            this.handleRequest(req, ODataHttpMethod.DELETE, resp, serviceFactory);
        } else if (ODataHttpMethod.PUT.name().equals(xHttpMethod)) {
            this.handleRequest(req, ODataHttpMethod.PUT, resp, serviceFactory);
        } else if (ODataHttpMethod.GET.name().equals(xHttpMethod)) {
            this.handleRequest(req, ODataHttpMethod.GET, resp, serviceFactory);
        } else if (ODataHttpMethod.POST.name().equals(xHttpMethod)) {
            this.handleRequest(req, ODataHttpMethod.POST, resp, serviceFactory);
        } else if (HTTP_METHOD_HEAD.equals(xHttpMethod) || HTTP_METHOD_OPTIONS.equals(xHttpMethod)) {
            this.createNotImplementedResponse(req, ODataNotImplementedException.COMMON, resp, serviceFactory);
        } else {
            this.createNotImplementedResponse(req, ODataNotImplementedException.COMMON, resp, serviceFactory);
        }
        return true;
    }

    private void handleRequest(HttpServletRequest req, ODataHttpMethod method, HttpServletResponse resp, ODataServiceFactory serviceFactory) throws IOException {
        try {
            String pathSplitAsString = this.getInitParameter("org.apache.olingo.odata2.path.split");
            int pathSplit = 0;
            if (pathSplitAsString != null) {
                pathSplit = Integer.parseInt(pathSplitAsString);
            }
            if (req.getHeader("Accept") != null && req.getHeader("Accept").isEmpty()) {
                this.createNotAcceptableResponse(req, ODataNotAcceptableException.COMMON, resp, serviceFactory);
            }
            ODataRequest odataRequest = ODataRequest.method(method).contentType(RestUtil.extractRequestContentType(req.getContentType()).toContentTypeString()).acceptHeaders(RestUtil.extractAcceptHeaders(req.getHeader("Accept"))).acceptableLanguages(RestUtil.extractAcceptableLanguage(req.getHeader("Accept-Language"))).pathInfo(RestUtil.buildODataPathInfo(req, pathSplit)).allQueryParameters(RestUtil.extractAllQueryParameters(req.getQueryString())).requestHeaders(RestUtil.extractHeaders(req)).body((InputStream)req.getInputStream()).build();
            ODataContextImpl context = new ODataContextImpl(odataRequest, serviceFactory);
            context.setParameter("~httpRequestObject", req);
            ODataService service = serviceFactory.createService(context);
            if (service == null) {
                this.createServiceUnavailableResponse(req, ODataInternalServerErrorException.NOSERVICE, resp, serviceFactory);
            } else {
                context.setService(service);
                service.getProcessor().setContext(context);
                ODataRequestHandler requestHandler = new ODataRequestHandler(serviceFactory, service, context);
                ODataResponse odataResponse = requestHandler.handle(odataRequest);
                this.createResponse(resp, odataResponse);
            }
        }
        catch (Exception e) {
            ODataExceptionWrapper wrapper = new ODataExceptionWrapper(req, serviceFactory);
            this.createResponse(resp, wrapper.wrapInExceptionResponse(e));
        }
    }

    private ODataServiceFactory createServiceFactory(HttpServletRequest req) {
        try {
            String factoryClassName = this.getInitParameter("org.apache.olingo.odata2.service.factory");
            ClassLoader cl = (ClassLoader)req.getAttribute("org.apache.olingo.odata2.service.factory.classloader");
            if (cl == null) {
                return (ODataServiceFactory)Class.forName(factoryClassName).newInstance();
            }
            return (ODataServiceFactory)Class.forName(factoryClassName, true, cl).newInstance();
        }
        catch (Exception e) {
            throw new ODataRuntimeException(e);
        }
    }

    private void handleRedirect(HttpServletRequest req, HttpServletResponse resp, ODataServiceFactory serviceFactory) throws IOException {
        String method = req.getMethod();
        if (ODataHttpMethod.GET.name().equals(method) || ODataHttpMethod.POST.name().equals(method) || ODataHttpMethod.PUT.name().equals(method) || ODataHttpMethod.DELETE.name().equals(method) || ODataHttpMethod.PATCH.name().equals(method) || ODataHttpMethod.MERGE.name().equals(method) || HTTP_METHOD_HEAD.equals(method) || HTTP_METHOD_OPTIONS.equals(method)) {
            ODataResponse odataResponse = ODataResponse.status(HttpStatusCodes.TEMPORARY_REDIRECT).header("Location", this.createLocation(req)).build();
            this.createResponse(resp, odataResponse);
        } else {
            this.createNotImplementedResponse(req, ODataHttpException.COMMON, resp, serviceFactory);
        }
    }

    private String createLocation(HttpServletRequest req) {
        String servletPath;
        StringBuilder location = new StringBuilder();
        String contextPath = req.getContextPath();
        if (contextPath != null) {
            location.append(contextPath);
        }
        if ((servletPath = req.getServletPath()) != null) {
            location.append(servletPath);
        }
        location.append("/");
        return location.toString();
    }

    private void createResponse(HttpServletResponse resp, ODataResponse response) throws IOException {
        resp.setStatus(response.getStatus().getStatusCode());
        resp.setContentType(response.getContentHeader());
        for (String headerName : response.getHeaderNames()) {
            resp.setHeader(headerName, response.getHeader(headerName));
        }
        Object entity = response.getEntity();
        if (entity != null) {
            ServletOutputStream out = resp.getOutputStream();
            int contentLength = 0;
            if (entity instanceof InputStream) {
                int curByte;
                while ((curByte = ((InputStream)entity).read()) != -1) {
                    ++contentLength;
                    out.write((int)((char)curByte));
                }
                ((InputStream)entity).close();
            } else if (entity instanceof String) {
                String body = (String)entity;
                byte[] entityBytes = body.getBytes("utf-8");
                out.write(entityBytes);
                contentLength = entityBytes.length;
            }
            if (response.getHeader("Content-Length") != null) {
                try {
                    contentLength = Integer.parseInt(response.getHeader("Content-Length"));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            resp.setContentLength(contentLength);
            out.flush();
            out.close();
        }
    }

    private void createNotImplementedResponse(HttpServletRequest req, MessageReference messageReference, HttpServletResponse resp, ODataServiceFactory serviceFactory) throws IOException {
        ODataExceptionWrapper exceptionWrapper = new ODataExceptionWrapper(req, serviceFactory);
        ODataResponse response = exceptionWrapper.wrapInExceptionResponse(new ODataNotImplementedException(messageReference));
        this.createResponse(resp, response);
    }

    private void createMethodNotAllowedResponse(HttpServletRequest req, MessageReference messageReference, HttpServletResponse resp, ODataServiceFactory serviceFactory) throws IOException {
        ODataExceptionWrapper exceptionWrapper = new ODataExceptionWrapper(req, serviceFactory);
        ODataResponse response = exceptionWrapper.wrapInExceptionResponse(new ODataMethodNotAllowedException(messageReference));
        this.createResponse(resp, response);
    }

    private void createNotAcceptableResponse(HttpServletRequest req, MessageReference messageReference, HttpServletResponse resp, ODataServiceFactory serviceFactory) throws IOException {
        ODataExceptionWrapper exceptionWrapper = new ODataExceptionWrapper(req, serviceFactory);
        ODataResponse response = exceptionWrapper.wrapInExceptionResponse(new ODataNotAcceptableException(messageReference));
        this.createResponse(resp, response);
    }

    private void createServiceUnavailableResponse(HttpServletRequest req, MessageReference messageReference, HttpServletResponse resp, ODataServiceFactory serviceFactory) throws IOException {
        ODataExceptionWrapper exceptionWrapper = new ODataExceptionWrapper(req, serviceFactory);
        ODataResponse response = exceptionWrapper.wrapInExceptionResponse(new ODataInternalServerErrorException(messageReference));
        this.createResponse(resp, response);
    }
}

