/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.uri;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.uri.ExpandSelectTreeNode;
import org.apache.olingo.odata2.api.uri.NavigationPropertySegment;
import org.apache.olingo.odata2.api.uri.SelectItem;
import org.apache.olingo.odata2.core.uri.ExpandSelectTreeNodeImpl;

public class ExpandSelectTreeCreator {
    private List<SelectItem> initialSelect;
    private List<ArrayList<NavigationPropertySegment>> initialExpand;

    public ExpandSelectTreeCreator(List<SelectItem> select, List<ArrayList<NavigationPropertySegment>> expand) {
        this.initialSelect = select != null ? select : Collections.emptyList();
        this.initialExpand = expand != null ? expand : Collections.emptyList();
    }

    public ExpandSelectTreeNodeImpl create() throws EdmException {
        ExpandSelectTreeNodeImpl root = new ExpandSelectTreeNodeImpl();
        if (!this.initialSelect.isEmpty()) {
            this.createSelectTree(root);
        } else {
            root.setExplicitlySelected();
        }
        this.mergeExpandTree(root);
        this.consolidate(root);
        return root;
    }

    private void consolidate(ExpandSelectTreeNodeImpl node) {
        switch (node.getAllKind()) {
            case EXPLICITLYTRUE: 
            case IMPLICITLYTRUE: {
                this.consolidateTrueNode(node);
                break;
            }
            case FALSE: {
                this.consolidateFalseNode(node);
            }
        }
    }

    private void consolidateFalseNode(ExpandSelectTreeNodeImpl node) {
        for (Map.Entry<String, ExpandSelectTreeNode> entry : node.getLinks().entrySet()) {
            ExpandSelectTreeNodeImpl subNode = (ExpandSelectTreeNodeImpl)entry.getValue();
            if (!subNode.isExpanded()) {
                node.putLink(entry.getKey(), null);
                continue;
            }
            this.consolidate(subNode);
        }
    }

    private void consolidateTrueNode(ExpandSelectTreeNodeImpl node) {
        Map<String, ExpandSelectTreeNode> links = node.getLinks();
        Set<Map.Entry<String, ExpandSelectTreeNode>> linkEntries = links.entrySet();
        ArrayList<String> toRemove = new ArrayList<String>();
        for (Map.Entry<String, ExpandSelectTreeNode> entry : linkEntries) {
            ExpandSelectTreeNodeImpl subNode = (ExpandSelectTreeNodeImpl)entry.getValue();
            if (subNode.isExpanded() && node.isExplicitlySelected()) {
                subNode.setExplicitlySelected();
                this.consolidate(subNode);
                continue;
            }
            if (subNode.isExpanded()) {
                this.consolidate(subNode);
                continue;
            }
            toRemove.add(entry.getKey());
        }
        for (String key : toRemove) {
            node.removeLink(key);
        }
    }

    private void createSelectTree(ExpandSelectTreeNodeImpl root) throws EdmException {
        for (SelectItem item : this.initialSelect) {
            ExpandSelectTreeNodeImpl actualNode = root;
            for (NavigationPropertySegment navSegement : item.getNavigationPropertySegments()) {
                actualNode = this.addSelectNode(actualNode, navSegement.getNavigationProperty().getName());
            }
            if (item.getProperty() != null) {
                actualNode.addProperty(item.getProperty());
                continue;
            }
            if (item.isStar()) {
                actualNode.setAllExplicitly();
                continue;
            }
            actualNode.setExplicitlySelected();
        }
    }

    private ExpandSelectTreeNodeImpl addSelectNode(ExpandSelectTreeNodeImpl actualNode, String navigationPropertyName) {
        Map<String, ExpandSelectTreeNode> links = actualNode.getLinks();
        if (!links.containsKey(navigationPropertyName)) {
            ExpandSelectTreeNodeImpl subNode = new ExpandSelectTreeNodeImpl();
            actualNode.putLink(navigationPropertyName, subNode);
            if (actualNode.isExplicitlySelected()) {
                subNode.setExplicitlySelected();
            } else if (actualNode.getAllKind() == ExpandSelectTreeNodeImpl.AllKinds.IMPLICITLYTRUE) {
                actualNode.setAllKindFalse();
            }
            return subNode;
        }
        return (ExpandSelectTreeNodeImpl)links.get(navigationPropertyName);
    }

    private void mergeExpandTree(ExpandSelectTreeNodeImpl root) throws EdmException {
        for (ArrayList<NavigationPropertySegment> singleExpand : this.initialExpand) {
            NavigationPropertySegment navSegment;
            ExpandSelectTreeNodeImpl actualNode = root;
            Iterator<NavigationPropertySegment> i$ = singleExpand.iterator();
            while (i$.hasNext() && (actualNode = this.addExpandNode(actualNode, (navSegment = i$.next()).getNavigationProperty().getName())) != null) {
            }
        }
    }

    private ExpandSelectTreeNodeImpl addExpandNode(ExpandSelectTreeNodeImpl actualNode, String navigationPropertyName) {
        Map<String, ExpandSelectTreeNode> links = actualNode.getLinks();
        if (!links.containsKey(navigationPropertyName)) {
            if (actualNode.isExplicitlySelected() || actualNode.isExplicitlySelected() && actualNode.isExpanded()) {
                ExpandSelectTreeNodeImpl subNode = new ExpandSelectTreeNodeImpl();
                subNode.setExpanded();
                subNode.setExplicitlySelected();
                actualNode.putLink(navigationPropertyName, subNode);
                return subNode;
            }
            return null;
        }
        ExpandSelectTreeNodeImpl subNode = (ExpandSelectTreeNodeImpl)links.get(navigationPropertyName);
        subNode.setExpanded();
        return subNode;
    }
}

