/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.uri.expression;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.uri.expression.CommonExpression;
import org.apache.olingo.odata2.api.uri.expression.ExceptionVisitExpression;
import org.apache.olingo.odata2.api.uri.expression.ExpressionKind;
import org.apache.olingo.odata2.api.uri.expression.ExpressionVisitor;
import org.apache.olingo.odata2.api.uri.expression.OrderByExpression;
import org.apache.olingo.odata2.api.uri.expression.OrderExpression;

public class OrderByExpressionImpl
implements OrderByExpression {
    private String orderbyString;
    List<OrderExpression> orders;

    public OrderByExpressionImpl(String orderbyString) {
        this.orderbyString = orderbyString;
        this.orders = new ArrayList<OrderExpression>();
    }

    @Override
    public String getExpressionString() {
        return this.orderbyString;
    }

    @Override
    public List<OrderExpression> getOrders() {
        return this.orders;
    }

    @Override
    public int getOrdersCount() {
        return this.orders.size();
    }

    public void addOrder(OrderExpression orderNode) {
        this.orders.add(orderNode);
    }

    @Override
    public ExpressionKind getKind() {
        return ExpressionKind.ORDERBY;
    }

    @Override
    public EdmType getEdmType() {
        return null;
    }

    @Override
    public CommonExpression setEdmType(EdmType edmType) {
        return this;
    }

    @Override
    public String getUriLiteral() {
        return this.orderbyString;
    }

    @Override
    public Object accept(ExpressionVisitor visitor) throws ExceptionVisitExpression, ODataApplicationException {
        ArrayList<Object> retParameters = new ArrayList<Object>();
        for (OrderExpression order : this.orders) {
            Object retParameter = order.accept(visitor);
            retParameters.add(retParameter);
        }
        Object ret = visitor.visitOrderByExpression(this, this.orderbyString, retParameters);
        return ret;
    }
}

