/*
 * Decompiled with CFR 0.152.
 */
package org.apache.onami.configuration.variables;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.onami.configuration.variables.Appender;
import org.apache.onami.configuration.variables.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractAppender
implements Appender {
    private static final Logger logger = Logger.getLogger(AbstractAppender.class.getName());
    protected final String chunk;

    protected AbstractAppender(String chunk) {
        this.chunk = chunk;
    }

    @Override
    public final void append(StringBuilder buffer, Map<String, String> configuration, Tree<Appender> context) {
        Tree<Appender> currentContext;
        Tree<Appender> tree = currentContext = context == null ? new Tree<Appender>(this) : context.addLeaf(this);
        if (currentContext.inAncestors(this)) {
            buffer.append(this.chunk);
            logger.warning(String.format("Recursion detected within variable resolving:%n%s", currentContext.getRoot()));
        } else {
            this.doAppend(buffer, configuration, currentContext);
            if (currentContext.isRoot() && logger.isLoggable(Level.FINEST)) {
                logger.finest(String.format("Resolving variables:%n%s", currentContext));
            }
        }
    }

    @Override
    public String resolve(Map<String, String> configuration) {
        StringBuilder buffer = new StringBuilder();
        this.append(buffer, configuration, null);
        return buffer.toString();
    }

    protected abstract void doAppend(StringBuilder var1, Map<String, String> var2, Tree<Appender> var3);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public final String toString() {
        return this.chunk;
    }
}

