/*
 * Decompiled with CFR 0.152.
 */
package org.apache.onami.configuration.variables;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Tree<T> {
    private T data;
    private Tree<T> parent = null;
    private List<Tree<T>> children = new ArrayList<Tree<T>>();

    public Tree(T data) {
        this.data = data;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public Tree<T> addLeaf(T child) {
        Tree<T> leaf = new Tree<T>(child);
        leaf.parent = this;
        this.children.add(leaf);
        return leaf;
    }

    public Tree<T> getParent() {
        return this.parent;
    }

    public void removeFromParent() {
        if (!this.isRoot()) {
            this.getParent().removeSubtree(this);
        }
    }

    public void removeSubtree(Tree<T> subtree) {
        if (this.children.remove(subtree)) {
            subtree.parent = null;
        }
    }

    public T getData() {
        return this.data;
    }

    public int getDepth() {
        int depth = 0;
        Tree<T> curr = this.parent;
        while (curr != null) {
            curr = curr.parent;
            ++depth;
        }
        return depth;
    }

    public List<Tree<T>> getChildren() {
        return this.children;
    }

    public Tree<T> addSubtree(Tree<T> subtree) {
        Tree<T> copy = this.addLeaf(subtree.data);
        copy.children = new ArrayList<Tree<T>>(subtree.children);
        return copy;
    }

    public boolean inSubtrees(T element) {
        for (Tree<T> child : this.getChildren()) {
            if (!child.isElement(element) && !child.inSubtrees(element)) continue;
            return true;
        }
        return false;
    }

    public boolean isElement(T element) {
        return this.data.equals(element);
    }

    public boolean inAncestors(T element) {
        if (!this.isRoot()) {
            return this.getParent().isElement(element) || this.getParent().inAncestors(element);
        }
        return false;
    }

    public Tree<T> getRoot() {
        if (this.isRoot()) {
            return this;
        }
        return this.getParent().getRoot();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer, 0);
        return buffer.toString();
    }

    private void toString(StringBuilder buffer, int level) {
        StringBuilder indent = new StringBuilder();
        Tree<T> curr = this;
        for (int i = level - 1; i >= 0; --i) {
            Tree<T> prev = curr;
            curr = prev.parent;
            if (i == level - 1) {
                indent.append(" _|");
                continue;
            }
            indent.append("  ");
            if (i < level && curr.children.indexOf(prev) < curr.children.size() - 1) {
                indent.append("|");
                continue;
            }
            indent.append(" ");
        }
        buffer.append((CharSequence)indent.reverse());
        buffer.append(this.getData()).append("\n");
        for (Tree<T> child : this.getChildren()) {
            super.toString(buffer, level + 1);
        }
    }
}

