/*
 * Decompiled with CFR 0.152.
 */
package org.ggf.drmaa;

import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import org.ggf.drmaa.PartialTimestamp;

public class PartialTimestampFormat
extends Format {
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private NumberFormat nf = NumberFormat.getIntegerInstance();

    public PartialTimestampFormat() {
        this.nf.setMinimumIntegerDigits(2);
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (!(obj instanceof PartialTimestamp)) {
            throw new IllegalArgumentException("Cannot parse " + obj.getClass().getName());
        }
        return this.format((PartialTimestamp)obj, stringBuffer, fieldPosition);
    }

    public StringBuffer format(PartialTimestamp obj, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        boolean fieldSet = false;
        if (stringBuffer == null) {
            throw new NullPointerException("stringBuffer parameter is null");
        }
        if (fieldPosition == null) {
            throw new NullPointerException("fieldPosition parameter is null");
        }
        if (obj.isSet(0)) {
            stringBuffer.append(this.nf.format(obj.get(0)));
            fieldSet = true;
        }
        if (obj.isSet(1)) {
            stringBuffer.append(this.nf.format(obj.get(1)));
            fieldSet = true;
        } else if (fieldSet) {
            throw new IllegalArgumentException("In PartialTimestamp object, CENTURY is set but YEAR is not");
        }
        if (obj.isSet(2)) {
            if (fieldSet) {
                stringBuffer.append('/');
            }
            stringBuffer.append(this.nf.format(obj.get(2) + 1));
            fieldSet = true;
        } else if (fieldSet) {
            throw new IllegalArgumentException("In PartialTimestamp object, YEAR is set but MONTH is not");
        }
        if (obj.isSet(5)) {
            if (fieldSet) {
                stringBuffer.append('/');
            }
            stringBuffer.append(this.nf.format(obj.get(5)));
            fieldSet = true;
        } else if (fieldSet) {
            throw new IllegalArgumentException("In PartialTimestamp object, MONTH is set but DAY_OF_MONTH is not");
        }
        if (obj.isSet(11)) {
            if (fieldSet) {
                stringBuffer.append(' ');
            }
        } else {
            throw new IllegalArgumentException("In PartialTimestamp object, HOUR_OF_DAY is not set");
        }
        stringBuffer.append(this.nf.format(obj.get(11)));
        if (!obj.isSet(12)) {
            throw new IllegalArgumentException("In PartialTimestamp object, MINUTE is not set");
        }
        stringBuffer.append(':');
        stringBuffer.append(this.nf.format(obj.get(12)));
        if (obj.isSet(13)) {
            stringBuffer.append(':');
            stringBuffer.append(this.nf.format(obj.get(13)));
        }
        if (obj.isSet(15)) {
            int offset = obj.get(15);
            stringBuffer.append(' ');
            if (offset < 0) {
                stringBuffer.append('-');
                offset *= -1;
            } else {
                stringBuffer.append('+');
            }
            int hours = offset / 3600000;
            stringBuffer.append(this.nf.format(hours));
            stringBuffer.append(':');
            int minutes = (offset %= 3600000) / 60000;
            stringBuffer.append(this.nf.format(minutes));
        }
        return stringBuffer;
    }

    public String format(PartialTimestamp obj) {
        StringBuffer buffer = this.format(obj, new StringBuffer(), new FieldPosition(0));
        return buffer.toString();
    }

    public PartialTimestamp parse(String str) throws ParseException {
        ParsePosition pp = new ParsePosition(0);
        PartialTimestamp pt = this.parse(str, pp);
        if (pp.getErrorIndex() >= 0) {
            throw new ParseException("Unable to parse DRMAA date string: \"" + str + "\"", pp.getErrorIndex());
        }
        return pt;
    }

    public PartialTimestamp parse(String str, ParsePosition parsePosition) {
        return (PartialTimestamp)this.parseObject(str, parsePosition);
    }

    @Override
    public Object parseObject(String str, ParsePosition parsePosition) {
        if (parsePosition == null) {
            throw new NullPointerException("parsePosition parameter is null");
        }
        char[] chars = str.toCharArray();
        PartialTimestamp pt = new PartialTimestamp();
        char[][] fields = new char[][]{new char[4], new char[2], new char[2], new char[2], new char[2], new char[2], new char[1], new char[2], new char[2]};
        int field = 0;
        int count = 0;
        boolean inWhitespace = false;
        int whitespaceIndex = 0;
        int minuteIndex = 0;
        int tzIndex = 0;
        int field_count = 0;
        while (field_count < fields.length) {
            int char_count = 0;
            while (char_count < fields[field_count].length) {
                fields[field_count][char_count] = 32;
                ++char_count;
            }
            ++field_count;
        }
        int index = parsePosition.getIndex();
        while (index < chars.length) {
            if (field != 6 && (field == 0 && count < 4 || field > 0 && count < 2) && Character.isDigit(chars[index])) {
                if (field == 4 && count == 0) {
                    minuteIndex = index;
                }
                fields[field][count] = chars[index];
                ++count;
                inWhitespace = false;
            } else if (field != 1 && field != 2 && field != 5 && field != 6 && count == 2 && chars[index] == ':') {
                field = field == 0 ? 4 : ++field;
                count = 0;
                inWhitespace = false;
            } else if (field < 2 && (count == 2 || count == 4) && chars[index] == '/') {
                ++field;
                count = 0;
                inWhitespace = false;
            } else if (field != 3 && field != 6 && field != 7 && chars[index] == ' ' && (count == 0 || count == 2)) {
                if (!inWhitespace) {
                    if (field == 0 && count == 2) {
                        field = 3;
                    } else if (field == 1 && count == 2) {
                        field = 3;
                    } else if (field == 4 && count == 2) {
                        field = 6;
                    } else if (count == 2) {
                        ++field;
                    }
                    count = 0;
                    inWhitespace = true;
                    whitespaceIndex = index;
                }
            } else if (field == 6 && (chars[index] == '-' || chars[index] == '+')) {
                tzIndex = index;
                fields[field][0] = chars[index];
                ++field;
                count = 0;
                inWhitespace = false;
            } else {
                if (!(inWhitespace || count != 2 || field != 4 && field != 5 && field != 8)) {
                    parsePosition.setIndex(index);
                    break;
                }
                if (inWhitespace && count == 0 && (field == 5 || field == 6)) {
                    parsePosition.setIndex(whitespaceIndex);
                    break;
                }
                parsePosition.setErrorIndex(index);
                return null;
            }
            ++index;
        }
        if (count != 0 && count != 2 && count != 4) {
            parsePosition.setErrorIndex(chars.length);
            return null;
        }
        if (Character.isDigit(fields[3][0])) {
            pt.set(11, Integer.parseInt(new String(fields[3])));
            if (Character.isDigit(fields[2][0])) {
                pt.set(5, Integer.parseInt(new String(fields[2])));
                pt.set(2, Integer.parseInt(new String(fields[1])) - 1);
                String year = new String(fields[0]).trim();
                if (year.length() == 4) {
                    pt.set(1, Integer.parseInt(year.substring(2, 4)));
                    pt.set(0, Integer.parseInt(year.substring(0, 2)));
                } else {
                    pt.set(1, Integer.parseInt(year));
                }
            } else if (Character.isDigit(fields[1][0])) {
                pt.set(5, Integer.parseInt(new String(fields[1])));
                String month = new String(fields[0]).trim();
                if (month.length() != 2) {
                    parsePosition.setErrorIndex(7);
                    return null;
                }
                pt.set(2, Integer.parseInt(month) - 1);
            } else if (Character.isDigit(fields[0][0])) {
                String day = new String(fields[0]).trim();
                if (day.length() != 2) {
                    parsePosition.setErrorIndex(4);
                    return null;
                }
                pt.set(5, Integer.parseInt(day));
            }
        } else if (Character.isDigit(fields[0][0])) {
            String hour = new String(fields[0]).trim();
            if (hour.length() != 2) {
                parsePosition.setErrorIndex(4);
                return null;
            }
            pt.set(11, Integer.parseInt(hour));
        } else {
            parsePosition.setErrorIndex(0);
            return null;
        }
        if (!Character.isDigit(fields[4][0])) {
            parsePosition.setErrorIndex(minuteIndex);
            return null;
        }
        pt.set(12, Integer.parseInt(new String(fields[4])));
        if (Character.isDigit(fields[5][0])) {
            pt.set(13, Integer.parseInt(new String(fields[5])));
        }
        if (fields[6][0] != ' ' && Character.isDigit(fields[7][0]) && Character.isDigit(fields[8][0])) {
            int offset = Integer.parseInt(new String(fields[7])) * 3600000;
            offset += Integer.parseInt(new String(fields[8])) * 60000;
            if (fields[6][0] == '-') {
                offset *= -1;
            }
            pt.set(15, offset);
        } else if (fields[6][0] != ' ' || Character.isDigit(fields[7][0]) || Character.isDigit(fields[8][0])) {
            if (fields[6][0] != ' ') {
                tzIndex = Character.isDigit(fields[7][0]) ? (chars.length > tzIndex + 3 && chars[tzIndex + 3] == ':' ? (tzIndex += 4) : (tzIndex += 3)) : ++tzIndex;
            }
            parsePosition.setErrorIndex(tzIndex);
            return null;
        }
        return pt;
    }
}

