/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.configuration.AnnotationEngine;
import org.mockito.exceptions.Reporter;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.util.reflection.FieldSetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAnnotationEngine
implements AnnotationEngine {
    @Override
    public Object createMockFor(Annotation annotation, Field field) {
        if (annotation instanceof Mock) {
            return this.processAnnotationOn((Mock)annotation, field);
        }
        if (annotation instanceof MockitoAnnotations.Mock) {
            return this.processAnnotationOn((MockitoAnnotations.Mock)annotation, field);
        }
        if (annotation instanceof Captor) {
            return this.processAnnotationOn((Captor)annotation, field);
        }
        return null;
    }

    private Object processAnnotationOn(Mock annotation, Field field) {
        MockSettings mockSettings = Mockito.withSettings();
        if (annotation.extraInterfaces().length > 0) {
            mockSettings.extraInterfaces(annotation.extraInterfaces());
        }
        if ("".equals(annotation.name())) {
            mockSettings.name(field.getName());
        } else {
            mockSettings.name(annotation.name());
        }
        mockSettings.defaultAnswer(annotation.answer().get());
        return Mockito.mock(field.getType(), mockSettings);
    }

    private Object processAnnotationOn(MockitoAnnotations.Mock annotation, Field field) {
        return Mockito.mock(field.getType(), field.getName());
    }

    private Object processAnnotationOn(Captor annotation, Field field) {
        Class<?> type = field.getType();
        if (!ArgumentCaptor.class.isAssignableFrom(type)) {
            throw new MockitoException("@Captor field must be of the type ArgumentCaptor.\nField: '" + field.getName() + "' has wrong type\n" + "For info how to use @Captor annotations see examples in javadoc for MockitoAnnotations class.");
        }
        return ArgumentCaptor.forClass(Object.class);
    }

    @Override
    public void process(Class<?> clazz, Object testClass) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            boolean alreadyAssigned = false;
            for (Annotation annotation : field.getAnnotations()) {
                Object mock = this.createMockFor(annotation, field);
                if (mock == null) continue;
                this.throwIfAlreadyAssigned(field, alreadyAssigned);
                alreadyAssigned = true;
                try {
                    new FieldSetter(testClass, field).set(mock);
                }
                catch (Exception e) {
                    throw new MockitoException("Problems setting field " + field.getName() + " annotated with " + annotation, e);
                }
            }
        }
    }

    void throwIfAlreadyAssigned(Field field, boolean alreadyAssigned) {
        if (alreadyAssigned) {
            new Reporter().moreThanOneAnnotationNotAllowed(field.getName());
        }
    }
}

