/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.exceptions.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class StackTraceFilter {
    public boolean isBad(StackTraceElement e) {
        boolean fromMockObject = e.getClassName().contains("$$EnhancerByMockitoWithCGLIB$$");
        boolean fromOrgMockito = e.getClassName().startsWith("org.mockito.");
        boolean isRunner = e.getClassName().startsWith("org.mockito.runners.");
        boolean isInternalRunner = e.getClassName().startsWith("org.mockito.internal.runners.");
        return (fromMockObject || fromOrgMockito) && !isRunner && !isInternalRunner;
    }

    public StackTraceElement[] filter(StackTraceElement[] target, boolean keepTop) {
        List<StackTraceElement> unfilteredStackTrace = Arrays.asList(target);
        int lastBad = -1;
        int firstBad = -1;
        for (int i = 0; i < unfilteredStackTrace.size(); ++i) {
            if (!this.isBad(unfilteredStackTrace.get(i))) continue;
            lastBad = i;
            if (firstBad != -1) continue;
            firstBad = i;
        }
        List<Object> top = keepTop && firstBad != -1 ? unfilteredStackTrace.subList(0, firstBad) : new LinkedList();
        List<StackTraceElement> bottom = unfilteredStackTrace.subList(lastBad + 1, unfilteredStackTrace.size());
        ArrayList<StackTraceElement> filtered = new ArrayList<StackTraceElement>(top);
        filtered.addAll(bottom);
        return filtered.toArray(new StackTraceElement[0]);
    }
}

