package org.objenesis.strategy;

import org.objenesis.instantiator.ObjectInstantiator;
import org.objenesis.instantiator.gcj.GCJInstantiator;
import org.objenesis.instantiator.sun.Sun13Instantiator;
import org.objenesis.instantiator.sun.SunReflectionFactoryInstantiator;

/**
 * Guess the best instantiator for a given class. The instantiator will instantiate the class
 * without calling any constructor. Currently, the selection doesn't depend on the class. It relies
 * on the
 * <ul>
 * <li>JVM version</li>
 * <li>JVM vendor</li>
 * <li>JVM vendor version</li>
 * </ul>
 * However, instantiators are stateful and so dedicated to their class.
 * 
 * @see ObjectInstantiator
 */
public class StdInstantiatorStrategy extends BaseInstantiatorStrategy {

   /**
    * Return an {@link ObjectInstantiator} allowing to create instance without any constructor being
    * called.
    * 
    * @param type Class to instantiate
    * @return The ObjectInstantiator for the class
    */
   public ObjectInstantiator newInstantiatorOf(Class type) {

      if(JVM_NAME.startsWith(SUN)) {
         if(VM_VERSION.startsWith("1.3")) {
            return new Sun13Instantiator(type);
         }
      }
      else if(JVM_NAME.startsWith(GNU)) {
         return new GCJInstantiator(type);
      }

      // Fallback instantiator, should work with:
      // - Java Hotspot version 1.4 and higher
      // - JRockit 1.4-R26 and higher
      // - IBM and Hitachi JVMs
      // ... might works for others so we just give it a try
      return new SunReflectionFactoryInstantiator(type);
   }
}