/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.impl.SLPCore;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.ArrayList;

class AuthenticationBlock {
    public static final short BSD_DSA = 2;
    private int timestamp;
    private byte[] data = null;
    private byte[] sig = null;
    private String spi = null;

    AuthenticationBlock(short s, String string, int n, byte[] byArray, byte[] byArray2) throws ServiceLocationException {
        this();
        if (s != 2) {
            throw new ServiceLocationException(16, "Only BSD 0x0002 (DSA) is supported.");
        }
        this.timestamp = n;
        this.data = byArray;
        this.spi = string;
        if (byArray2 == null) {
            this.sign();
        } else {
            this.sig = byArray2;
        }
    }

    AuthenticationBlock() {
    }

    private void sign() throws ServiceLocationException {
        try {
            PrivateKey privateKey = SLPCore.CONFIG.getPrivateKey(this.spi);
            SLPCore.platform.logDebug("Signing with SPI: " + this.spi);
            Signature signature = Signature.getInstance("SHA1withDSA");
            signature.initSign(privateKey);
            signature.update(this.data);
            this.sig = signature.sign();
        }
        catch (Exception exception) {
            SLPCore.platform.logError(exception.getMessage(), exception.fillInStackTrace());
            throw new ServiceLocationException(7, "Could not sign data");
        }
    }

    String getSPI() {
        return this.spi;
    }

    int getTimestamp() {
        return this.timestamp;
    }

    boolean verify(byte[] byArray) throws ServiceLocationException {
        try {
            PublicKey publicKey = SLPCore.CONFIG.getPublicKey(this.spi);
            Signature signature = Signature.getInstance("SHA1withDSA");
            signature.initVerify(publicKey);
            signature.update(byArray);
            boolean bl = signature.verify(this.sig);
            SLPCore.platform.logDebug((bl ? "Verified with SPI: " : "Verification failed with SPI: ") + this.spi);
            return bl;
        }
        catch (Exception exception) {
            SLPCore.platform.logError(exception.getMessage(), exception.fillInStackTrace());
            throw new ServiceLocationException(7, "Could not verify data with SPI: " + this.spi);
        }
    }

    int getLength() {
        return 10 + this.spi.getBytes().length + this.sig.length;
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(2);
        dataOutputStream.writeShort((short)this.getLength());
        dataOutputStream.writeInt(this.timestamp);
        byte[] byArray = this.spi.getBytes();
        dataOutputStream.writeShort(byArray.length);
        dataOutputStream.write(byArray);
        dataOutputStream.write(this.sig);
    }

    static AuthenticationBlock[] parse(DataInputStream dataInputStream) throws IOException, ServiceLocationException {
        ArrayList<AuthenticationBlock> arrayList = new ArrayList<AuthenticationBlock>();
        int n = dataInputStream.readByte();
        for (int i = 0; i < n; ++i) {
            AuthenticationBlock authenticationBlock = new AuthenticationBlock();
            short s = dataInputStream.readShort();
            if (s != 2) {
                throw new ServiceLocationException(7, "BSD " + s + " is not supported.");
            }
            short s2 = dataInputStream.readShort();
            authenticationBlock.timestamp = dataInputStream.readInt();
            authenticationBlock.spi = dataInputStream.readUTF();
            authenticationBlock.sig = new byte[s2 - 2 - 2 - 4 - 2 - authenticationBlock.spi.getBytes().length];
            try {
                dataInputStream.readFully(authenticationBlock.sig);
            }
            catch (IOException iOException) {
                throw new ServiceLocationException(2, iOException.getMessage());
            }
            arrayList.add(authenticationBlock);
        }
        if (!SLPCore.CONFIG.getSecurityEnabled()) {
            return new AuthenticationBlock[0];
        }
        return arrayList.toArray(new AuthenticationBlock[0]);
    }
}

