/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time;

import com.cronutils.mapper.WeekDay;
import com.cronutils.model.Cron;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.definition.DayOfWeekFieldDefinition;
import com.cronutils.model.field.expression.Always;
import com.cronutils.model.field.expression.QuestionMark;
import com.cronutils.model.field.value.SpecialChar;
import com.cronutils.model.time.ExecutionTimeBuilder;
import com.cronutils.model.time.NearestValue;
import com.cronutils.model.time.TimeNode;
import com.cronutils.model.time.generator.FieldValueGenerator;
import com.cronutils.model.time.generator.FieldValueGeneratorFactory;
import com.cronutils.model.time.generator.NoSuchValueException;
import com.cronutils.utils.Preconditions;
import com.cronutils.utils.VisibleForTesting;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionTime {
    private static final Logger log = LoggerFactory.getLogger(ExecutionTime.class);
    private CronDefinition cronDefinition;
    private FieldValueGenerator yearsValueGenerator;
    private CronField daysOfWeekCronField;
    private CronField daysOfMonthCronField;
    private TimeNode months;
    private TimeNode hours;
    private TimeNode minutes;
    private TimeNode seconds;

    @VisibleForTesting
    ExecutionTime(CronDefinition cronDefinition, FieldValueGenerator yearsValueGenerator, CronField daysOfWeekCronField, CronField daysOfMonthCronField, TimeNode months, TimeNode hours, TimeNode minutes, TimeNode seconds) {
        this.cronDefinition = Preconditions.checkNotNull(cronDefinition);
        this.yearsValueGenerator = Preconditions.checkNotNull(yearsValueGenerator);
        this.daysOfWeekCronField = Preconditions.checkNotNull(daysOfWeekCronField);
        this.daysOfMonthCronField = Preconditions.checkNotNull(daysOfMonthCronField);
        this.months = Preconditions.checkNotNull(months);
        this.hours = Preconditions.checkNotNull(hours);
        this.minutes = Preconditions.checkNotNull(minutes);
        this.seconds = Preconditions.checkNotNull(seconds);
    }

    public static ExecutionTime forCron(Cron cron) {
        Map<CronFieldName, CronField> fields = cron.retrieveFieldsAsMap();
        ExecutionTimeBuilder executionTimeBuilder = new ExecutionTimeBuilder(cron.getCronDefinition());
        block9: for (CronFieldName name : CronFieldName.values()) {
            if (fields.get((Object)name) == null) continue;
            switch (name) {
                case SECOND: {
                    executionTimeBuilder.forSecondsMatching(fields.get((Object)name));
                    continue block9;
                }
                case MINUTE: {
                    executionTimeBuilder.forMinutesMatching(fields.get((Object)name));
                    continue block9;
                }
                case HOUR: {
                    executionTimeBuilder.forHoursMatching(fields.get((Object)name));
                    continue block9;
                }
                case DAY_OF_WEEK: {
                    executionTimeBuilder.forDaysOfWeekMatching(fields.get((Object)name));
                    continue block9;
                }
                case DAY_OF_MONTH: {
                    executionTimeBuilder.forDaysOfMonthMatching(fields.get((Object)name));
                    continue block9;
                }
                case MONTH: {
                    executionTimeBuilder.forMonthsMatching(fields.get((Object)name));
                    continue block9;
                }
                case YEAR: {
                    executionTimeBuilder.forYearsMatching(fields.get((Object)name));
                    continue block9;
                }
            }
        }
        return executionTimeBuilder.build();
    }

    public ZonedDateTime nextExecution(ZonedDateTime date) {
        Preconditions.checkNotNull(date);
        try {
            ZonedDateTime nextMatch = this.nextClosestMatch(date);
            if (nextMatch.equals(date)) {
                nextMatch = this.nextClosestMatch(date.plusSeconds(1L));
            }
            return nextMatch;
        }
        catch (NoSuchValueException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private ZonedDateTime nextClosestMatch(ZonedDateTime date) throws NoSuchValueException {
        List<Integer> year = this.yearsValueGenerator.generateCandidates(date.getYear(), date.getYear());
        TimeNode days = null;
        int lowestMonth = this.months.getValues().get(0);
        int lowestHour = this.hours.getValues().get(0);
        int lowestMinute = this.minutes.getValues().get(0);
        int lowestSecond = this.seconds.getValues().get(0);
        if (year.isEmpty()) {
            int newYear = this.yearsValueGenerator.generateNextValue(date.getYear());
            days = this.generateDays(this.cronDefinition, ZonedDateTime.of(LocalDateTime.of(newYear, lowestMonth, 1, 0, 0), date.getZone()));
            return this.initDateTime(this.yearsValueGenerator.generateNextValue(date.getYear()), lowestMonth, days.getValues().get(0), lowestHour, lowestMinute, lowestSecond, date.getZone());
        }
        if (!this.months.getValues().contains(date.getMonthValue())) {
            NearestValue nearestValue = this.months.getNextValue(date.getMonthValue(), 0);
            int nextMonths = nearestValue.getValue();
            if (nearestValue.getShifts() > 0) {
                ZonedDateTime newDate = ZonedDateTime.of(LocalDateTime.of(date.getYear(), 1, 1, 0, 0, 0), date.getZone()).plusYears(nearestValue.getShifts());
                return this.nextClosestMatch(newDate);
            }
            if (nearestValue.getValue() < date.getMonthValue()) {
                date = date.plusYears(1L);
            }
            days = this.generateDays(this.cronDefinition, ZonedDateTime.of(LocalDateTime.of(date.getYear(), nextMonths, 1, 0, 0), date.getZone()));
            return this.initDateTime(date.getYear(), nextMonths, days.getValues().get(0), lowestHour, lowestMinute, lowestSecond, date.getZone());
        }
        days = this.generateDays(this.cronDefinition, date);
        if (!days.getValues().contains(date.getDayOfMonth())) {
            NearestValue nearestValue = days.getNextValue(date.getDayOfMonth(), 0);
            if (nearestValue.getShifts() > 0) {
                ZonedDateTime newDate = ZonedDateTime.of(LocalDateTime.of(date.getYear(), date.getMonthValue(), 1, 0, 0, 0), date.getZone()).plusMonths(nearestValue.getShifts());
                return this.nextClosestMatch(newDate);
            }
            if (nearestValue.getValue() < date.getDayOfMonth()) {
                date = date.plusMonths(1L);
            }
            return this.initDateTime(date.getYear(), date.getMonthValue(), nearestValue.getValue(), lowestHour, lowestMinute, lowestSecond, date.getZone());
        }
        if (!this.hours.getValues().contains(date.getHour())) {
            NearestValue nearestValue = this.hours.getNextValue(date.getHour(), 0);
            int nextHours = nearestValue.getValue();
            if (nearestValue.getShifts() > 0) {
                ZonedDateTime newDate = ZonedDateTime.of(LocalDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), 0, 0, 0), date.getZone()).plusDays(nearestValue.getShifts());
                return this.nextClosestMatch(newDate);
            }
            if (nearestValue.getValue() < date.getHour()) {
                date = date.plusDays(1L);
            }
            return this.initDateTime(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), nextHours, lowestMinute, lowestSecond, date.getZone());
        }
        if (!this.minutes.getValues().contains(date.getMinute())) {
            NearestValue nearestValue = this.minutes.getNextValue(date.getMinute(), 0);
            int nextMinutes = nearestValue.getValue();
            if (nearestValue.getShifts() > 0) {
                ZonedDateTime newDate = ZonedDateTime.of(LocalDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), 0, 0), date.getZone()).plusHours(nearestValue.getShifts());
                return this.nextClosestMatch(newDate);
            }
            if (nearestValue.getValue() < date.getMinute()) {
                date = date.plusHours(1L);
            }
            return this.initDateTime(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), nextMinutes, lowestSecond, date.getZone());
        }
        if (!this.seconds.getValues().contains(date.getSecond())) {
            NearestValue nearestValue = this.seconds.getNextValue(date.getSecond(), 0);
            int nextSeconds = nearestValue.getValue();
            if (nearestValue.getShifts() > 0) {
                ZonedDateTime newDate = ZonedDateTime.of(LocalDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), date.getMinute(), 0), date.getZone()).plusMinutes(nearestValue.getShifts());
                return this.nextClosestMatch(newDate);
            }
            if (nearestValue.getValue() < date.getSecond()) {
                date = date.plusMinutes(1L);
            }
            return this.initDateTime(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), date.getMinute(), nextSeconds, date.getZone());
        }
        return date;
    }

    private ZonedDateTime previousClosestMatch(ZonedDateTime date) throws NoSuchValueException {
        List<Integer> year = this.yearsValueGenerator.generateCandidates(date.getYear(), date.getYear());
        TimeNode days = this.generateDays(this.cronDefinition, date);
        int highestMonth = this.months.getValues().get(this.months.getValues().size() - 1);
        int highestDay = days.getValues().get(days.getValues().size() - 1);
        int highestHour = this.hours.getValues().get(this.hours.getValues().size() - 1);
        int highestMinute = this.minutes.getValues().get(this.minutes.getValues().size() - 1);
        int highestSecond = this.seconds.getValues().get(this.seconds.getValues().size() - 1);
        if (year.isEmpty()) {
            int highestDayOfMonth;
            int previousYear = this.yearsValueGenerator.generatePreviousValue(date.getYear());
            if (highestDay > 28 && highestDay > (highestDayOfMonth = LocalDate.of(previousYear, highestMonth, 1).lengthOfMonth())) {
                NearestValue nearestValue = days.getPreviousValue(highestDay, 1);
                if (nearestValue.getShifts() > 0) {
                    ZonedDateTime newDate = ZonedDateTime.of(LocalDateTime.of(previousYear, highestMonth, 1, 23, 59, 59), ZoneId.systemDefault()).minusMonths(nearestValue.getShifts()).with(TemporalAdjusters.lastDayOfMonth());
                    return this.previousClosestMatch(newDate);
                }
                highestDay = nearestValue.getValue();
            }
            return this.initDateTime(previousYear, highestMonth, highestDay, highestHour, highestMinute, highestSecond, date.getZone());
        }
        if (!this.months.getValues().contains(date.getMonthValue())) {
            NearestValue nearestValue = this.months.getPreviousValue(date.getMonthValue(), 0);
            int previousMonths = nearestValue.getValue();
            if (nearestValue.getShifts() > 0) {
                ZonedDateTime newDate = ZonedDateTime.of(LocalDateTime.of(date.getYear(), 12, 31, 23, 59, 59), date.getZone()).minusYears(nearestValue.getShifts());
                return this.previousClosestMatch(newDate);
            }
            return this.initDateTime(date.getYear(), previousMonths, highestDay, highestHour, highestMinute, highestSecond, date.getZone());
        }
        if (!days.getValues().contains(date.getDayOfMonth())) {
            NearestValue nearestValue = days.getPreviousValue(date.getDayOfMonth(), 0);
            if (nearestValue.getShifts() > 0) {
                ZonedDateTime newDate = ZonedDateTime.of(LocalDateTime.of(date.getYear(), date.getMonthValue(), 1, 23, 59, 59), date.getZone()).minusMonths(nearestValue.getShifts()).with(TemporalAdjusters.lastDayOfMonth());
                return this.previousClosestMatch(newDate);
            }
            return this.initDateTime(date.getYear(), date.getMonthValue(), nearestValue.getValue(), highestHour, highestMinute, highestSecond, date.getZone());
        }
        if (!this.hours.getValues().contains(date.getHour())) {
            NearestValue nearestValue = this.hours.getPreviousValue(date.getHour(), 0);
            if (nearestValue.getShifts() > 0) {
                ZonedDateTime newDate = ZonedDateTime.of(LocalDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), 23, 59, 59), date.getZone()).minusDays(nearestValue.getShifts());
                return this.previousClosestMatch(newDate);
            }
            return this.initDateTime(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), nearestValue.getValue(), highestMinute, highestSecond, date.getZone());
        }
        if (!this.minutes.getValues().contains(date.getMinute())) {
            NearestValue nearestValue = this.minutes.getPreviousValue(date.getMinute(), 0);
            if (nearestValue.getShifts() > 0) {
                ZonedDateTime newDate = ZonedDateTime.of(LocalDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), 59, 59), date.getZone()).minusHours(nearestValue.getShifts());
                return this.previousClosestMatch(newDate);
            }
            return this.initDateTime(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), nearestValue.getValue(), highestSecond, date.getZone());
        }
        if (!this.seconds.getValues().contains(date.getSecond())) {
            NearestValue nearestValue = this.seconds.getPreviousValue(date.getSecond(), 0);
            int previousSeconds = nearestValue.getValue();
            if (nearestValue.getShifts() > 0) {
                ZonedDateTime newDate = ZonedDateTime.of(LocalDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), date.getMinute(), 59), date.getZone()).minusMinutes(nearestValue.getShifts());
                return this.previousClosestMatch(newDate);
            }
            return this.initDateTime(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), date.getMinute(), previousSeconds, date.getZone());
        }
        return date;
    }

    private TimeNode generateDays(CronDefinition cronDefinition, ZonedDateTime date) {
        if (cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK) != null && cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_MONTH) != null) {
            return this.generateDaysDoWAndDoMSupported(cronDefinition, date);
        }
        if (cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK) == null) {
            return this.generateDayCandidatesUsingDoM(date);
        }
        return this.generateDayCandidatesUsingDoW(date, ((DayOfWeekFieldDefinition)cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK)).getMondayDoWValue());
    }

    private TimeNode generateDaysDoWAndDoMSupported(CronDefinition cronDefinition, ZonedDateTime date) {
        boolean questionMarkSupported = cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK).getConstraints().getSpecialChars().contains((Object)SpecialChar.QUESTION_MARK);
        if (questionMarkSupported) {
            return new TimeNode(this.generateDayCandidatesQuestionMarkSupportedUsingDoWAndDoM(date.getYear(), date.getMonthValue(), ((DayOfWeekFieldDefinition)cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK)).getMondayDoWValue()));
        }
        return new TimeNode(this.generateDayCandidatesQuestionMarkNotSupportedUsingDoWAndDoM(date.getYear(), date.getMonthValue(), ((DayOfWeekFieldDefinition)cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK)).getMondayDoWValue()));
    }

    public Duration timeToNextExecution(ZonedDateTime date) {
        return Duration.between(date, this.nextExecution(date));
    }

    public ZonedDateTime lastExecution(ZonedDateTime date) {
        Preconditions.checkNotNull(date);
        try {
            ZonedDateTime previousMatch = this.previousClosestMatch(date);
            if (previousMatch.equals(date)) {
                previousMatch = this.previousClosestMatch(date.minusSeconds(1L));
            }
            return previousMatch;
        }
        catch (NoSuchValueException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Duration timeFromLastExecution(ZonedDateTime date) {
        return Duration.between(this.lastExecution(date), date);
    }

    public boolean isMatch(ZonedDateTime date) {
        try {
            return this.nextExecution(this.lastExecution(date)).equals(date);
        }
        catch (IllegalArgumentException e) {
            boolean everythingInRange = false;
            try {
                everythingInRange = this.dateValuesInExpectedRanges(this.nextClosestMatch(date), date);
            }
            catch (NoSuchValueException noSuchValueException) {
                // empty catch block
            }
            try {
                everythingInRange = this.dateValuesInExpectedRanges(this.previousClosestMatch(date), date);
            }
            catch (NoSuchValueException noSuchValueException) {
                // empty catch block
            }
            return everythingInRange;
        }
    }

    private boolean dateValuesInExpectedRanges(ZonedDateTime validCronDate, ZonedDateTime date) {
        boolean everythingInRange = true;
        if (this.cronDefinition.getFieldDefinition(CronFieldName.YEAR) != null) {
            boolean bl = everythingInRange = validCronDate.getYear() == date.getYear();
        }
        if (this.cronDefinition.getFieldDefinition(CronFieldName.MONTH) != null) {
            boolean bl = everythingInRange = everythingInRange && validCronDate.getMonthValue() == date.getMonthValue();
        }
        if (this.cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_MONTH) != null) {
            boolean bl = everythingInRange = everythingInRange && validCronDate.getDayOfMonth() == date.getDayOfMonth();
        }
        if (this.cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK) != null) {
            boolean bl = everythingInRange = everythingInRange && validCronDate.getDayOfWeek().getValue() == date.getDayOfWeek().getValue();
        }
        if (this.cronDefinition.getFieldDefinition(CronFieldName.HOUR) != null) {
            boolean bl = everythingInRange = everythingInRange && validCronDate.getHour() == date.getHour();
        }
        if (this.cronDefinition.getFieldDefinition(CronFieldName.MINUTE) != null) {
            boolean bl = everythingInRange = everythingInRange && validCronDate.getMinute() == date.getMinute();
        }
        if (this.cronDefinition.getFieldDefinition(CronFieldName.SECOND) != null) {
            everythingInRange = everythingInRange && validCronDate.getSecond() == date.getSecond();
        }
        return everythingInRange;
    }

    private List<Integer> generateDayCandidatesQuestionMarkNotSupportedUsingDoWAndDoM(int year, int month, WeekDay mondayDoWValue) {
        LocalDate date = LocalDate.of(year, month, 1);
        int lengthOfMonth = date.lengthOfMonth();
        HashSet<Integer> candidates = new HashSet<Integer>();
        if (this.daysOfMonthCronField.getExpression() instanceof Always && this.daysOfWeekCronField.getExpression() instanceof Always) {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, lengthOfMonth));
        } else if (this.daysOfMonthCronField.getExpression() instanceof Always) {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, year, month, mondayDoWValue).generateCandidates(1, lengthOfMonth));
        } else if (this.daysOfWeekCronField.getExpression() instanceof Always) {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, lengthOfMonth));
        } else {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, year, month, mondayDoWValue).generateCandidates(1, lengthOfMonth));
            candidates.addAll(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, lengthOfMonth));
        }
        ArrayList<Integer> candidatesList = new ArrayList<Integer>(candidates);
        Collections.sort(candidatesList);
        return candidatesList;
    }

    private List<Integer> generateDayCandidatesQuestionMarkSupportedUsingDoWAndDoM(int year, int month, WeekDay mondayDoWValue) {
        LocalDate date = LocalDate.of(year, month, 1);
        int lengthOfMonth = date.lengthOfMonth();
        HashSet<Integer> candidates = new HashSet<Integer>();
        if (this.daysOfMonthCronField.getExpression() instanceof Always && this.daysOfWeekCronField.getExpression() instanceof Always) {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, lengthOfMonth));
        } else if (this.daysOfMonthCronField.getExpression() instanceof QuestionMark) {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, year, month, mondayDoWValue).generateCandidates(1, lengthOfMonth));
        } else if (this.daysOfWeekCronField.getExpression() instanceof QuestionMark) {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, lengthOfMonth));
        } else {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, year, month, mondayDoWValue).generateCandidates(1, lengthOfMonth));
            candidates.addAll(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, lengthOfMonth));
        }
        ArrayList<Integer> candidatesList = new ArrayList<Integer>(candidates);
        Collections.sort(candidatesList);
        return candidatesList;
    }

    private TimeNode generateDayCandidatesUsingDoM(ZonedDateTime reference) {
        LocalDate date = LocalDate.of(reference.getYear(), reference.getMonthValue(), 1);
        int lengthOfMonth = date.lengthOfMonth();
        HashSet<Integer> candidates = new HashSet<Integer>(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, reference.getYear(), reference.getMonthValue()).generateCandidates(1, lengthOfMonth));
        ArrayList<Integer> candidatesList = new ArrayList<Integer>(candidates);
        Collections.sort(candidatesList);
        return new TimeNode(candidatesList);
    }

    private TimeNode generateDayCandidatesUsingDoW(ZonedDateTime reference, WeekDay mondayDoWValue) {
        LocalDate date = LocalDate.of(reference.getYear(), reference.getMonthValue(), 1);
        int lengthOfMonth = date.lengthOfMonth();
        HashSet<Integer> candidates = new HashSet<Integer>(FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, reference.getYear(), reference.getMonthValue(), mondayDoWValue).generateCandidates(0, lengthOfMonth + 1));
        ArrayList<Integer> candidatesList = new ArrayList<Integer>(candidates);
        Collections.sort(candidatesList);
        return new TimeNode(candidatesList);
    }

    private ZonedDateTime initDateTime(int years, int monthsOfYear, int dayOfMonth, int hoursOfDay, int minutesOfHour, int secondsOfMinute, ZoneId timeZone) {
        ZonedDateTime date = ZonedDateTime.of(LocalDateTime.of(0, 1, 1, 0, 0, 0), timeZone).plusYears(years).plusMonths(monthsOfYear - 1).plusDays(dayOfMonth - 1).plusHours(hoursOfDay).plusMinutes(minutesOfHour).plusSeconds(secondsOfMinute);
        return this.ensureSameDate(date, years, monthsOfYear, dayOfMonth, hoursOfDay, minutesOfHour, secondsOfMinute);
    }

    private ZonedDateTime ensureSameDate(ZonedDateTime date, int years, int monthsOfYear, int dayOfMonth, int hoursOfDay, int minutesOfHour, int secondsOfMinute) {
        if (date.getSecond() != secondsOfMinute) {
            date = date.plusSeconds(secondsOfMinute - date.getSecond());
        }
        if (date.getMinute() != minutesOfHour) {
            date = date.plusMinutes(minutesOfHour - date.getMinute());
        }
        if (date.getHour() != hoursOfDay) {
            date = date.plusHours(hoursOfDay - date.getHour());
        }
        if (date.getDayOfMonth() != dayOfMonth) {
            date = date.plusDays(dayOfMonth - date.getDayOfMonth());
        }
        if (date.getMonthValue() != monthsOfYear) {
            date = date.plusMonths(monthsOfYear - date.getMonthValue());
        }
        if (date.getYear() != years) {
            date = date.plusYears(years - date.getYear());
        }
        return date;
    }
}

