/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.testing;

import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class AssertingLogger
extends Logger {
    private final List<LogEntry> entries = new ArrayList<LogEntry>();

    public AssertingLogger() {
        super("", null);
        this.addHandler(new AssertingHandler());
        this.setUseParentHandlers(false);
    }

    @Override
    public boolean isLoggable(Level level) {
        return true;
    }

    public String getMessage(int index) {
        return this.entries.get(index).message;
    }

    public void assertLogCount(int count) {
        Truth.assertThat((Integer)this.entries.size()).isEqualTo((Object)count);
    }

    public void assertLogEntry(int index, Level level, String message, Object ... parameters) {
        LogEntry entry = this.entries.get(index);
        Truth.assertThat((Object)entry.level).isEqualTo((Object)level);
        Truth.assertThat((String)entry.message).isEqualTo((Object)message);
        if (parameters.length == 0) {
            Truth.assertThat((Object[])entry.parameters).isNull();
        } else {
            Truth.assertWithMessage((String)"Wrong number of parameters: expected=%s, actual=%s", (Object[])new Object[]{Arrays.asList(parameters), Arrays.asList(entry.parameters)}).that(Integer.valueOf(entry.parameters.length)).isEqualTo((Object)parameters.length);
            for (int n = 0; n < parameters.length; ++n) {
                Object expected = parameters[n];
                Object actual = entry.parameters[n];
                if (expected == null) {
                    Truth.assertThat((Object)actual).isNull();
                    continue;
                }
                Truth.assertThat((Object)actual).isNotNull();
                if (expected.getClass() == actual.getClass()) {
                    Truth.assertThat((Object)actual).isEqualTo(expected);
                    continue;
                }
                Truth.assertThat((String)actual.toString()).isEqualTo((Object)expected.toString());
            }
        }
    }

    public void assertThrown(int index, Throwable thrown) {
        Truth.assertThat((Throwable)this.entries.get(index).thrown).isSameAs((Object)thrown);
    }

    private class AssertingHandler
    extends Handler {
        private AssertingHandler() {
        }

        @Override
        public void publish(LogRecord r) {
            AssertingLogger.this.entries.add(new LogEntry(r.getMessage(), r.getParameters(), r.getLevel(), r.getThrown()));
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }

    private static class LogEntry {
        private final String message;
        private final Object[] parameters;
        private final Level level;
        private final Throwable thrown;

        LogEntry(String message, Object[] parameters, Level level, Throwable thrown) {
            this.message = message;
            this.parameters = parameters;
            this.level = level;
            this.thrown = thrown;
        }
    }
}

