/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.testing;

import com.google.common.flogger.LogSite;
import com.google.common.flogger.backend.LogData;
import com.google.common.flogger.backend.LoggerBackend;
import com.google.common.flogger.testing.LogDataSubject;
import com.google.common.flogger.util.CallerFinder;
import com.google.common.flogger.util.Checks;
import com.google.common.flogger.util.StackBasedLogSite;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

@CheckReturnValue
public final class FakeLoggerBackend
extends LoggerBackend {
    private final String name;
    private Level minLevel = Level.INFO;
    private final List<LogData> logged = new ArrayList<LogData>();

    public FakeLoggerBackend() {
        this("com.example.MyClass");
    }

    public FakeLoggerBackend(String name) {
        this.name = (String)Checks.checkNotNull((Object)name, (String)"name");
    }

    public void setLevel(Level level) {
        this.minLevel = (Level)Checks.checkNotNull((Object)level, (String)"level");
    }

    public int getLoggedCount() {
        return this.logged.size();
    }

    public LogData getLogged(int n) {
        return this.logged.get(n);
    }

    public LogDataSubject assertLogged(int n) {
        return LogDataSubject.assertThat(this.logged.get(n));
    }

    public LogDataSubject assertLastLogged() {
        return this.assertLogged(this.logged.size() - 1);
    }

    public String getLoggerName() {
        return this.name;
    }

    public boolean isLoggable(Level loggedLevel) {
        return loggedLevel.intValue() >= this.minLevel.intValue();
    }

    public void log(LogData data) {
        this.logged.add(data);
    }

    public void handleError(RuntimeException error, LogData badData) {
        throw error;
    }

    public LogSite inferLogSite(Class<?> loggerClass, int stackFramesToSkip) {
        StackTraceElement caller = CallerFinder.findCallerOf(loggerClass, (Throwable)new Throwable(), (int)(stackFramesToSkip + 1));
        return caller != null ? new StackBasedLogSite(caller) : LogSite.INVALID;
    }
}

