/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.testing;

import com.google.common.flogger.MetadataKey;
import com.google.common.flogger.backend.Metadata;
import com.google.common.flogger.util.Checks;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class FakeMetadata
extends Metadata {
    private final List<KeyValuePair> entries = new ArrayList<KeyValuePair>();

    public <T> FakeMetadata add(MetadataKey<T> key, T value) {
        this.entries.add(new KeyValuePair(key, value));
        return this;
    }

    public int size() {
        return this.entries.size();
    }

    public MetadataKey<?> getKey(int n) {
        return this.entries.get(n).key;
    }

    public Object getValue(int n) {
        return this.entries.get(n).value;
    }

    @Nullable
    public <T> T findValue(MetadataKey<T> key) {
        for (KeyValuePair e : this.entries) {
            if (!e.key.equals(key)) continue;
            return (T)key.cast(e.value);
        }
        return null;
    }

    private static final class KeyValuePair<T> {
        private final MetadataKey<T> key;
        private final T value;

        private KeyValuePair(MetadataKey<T> key, T value) {
            this.key = (MetadataKey)Checks.checkNotNull(key, (String)"key");
            this.value = Checks.checkNotNull(value, (String)"value");
        }
    }
}

