/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.testing;

import com.google.common.flogger.backend.FormatType;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import javax.annotation.Nullable;

public final class FormatTypeSubject
extends Subject<FormatTypeSubject, FormatType> {
    private static final Subject.Factory<FormatTypeSubject, FormatType> FORMAT_TYPE_SUBJECT_FACTORY = FormatTypeSubject::new;

    public static FormatTypeSubject assertThat(@Nullable FormatType formatType) {
        return (FormatTypeSubject)Truth.assertAbout(FORMAT_TYPE_SUBJECT_FACTORY).that((Object)formatType);
    }

    private FormatTypeSubject(FailureMetadata failureMetadata, @Nullable FormatType subject) {
        super(failureMetadata, (Object)subject);
    }

    public void canFormat(Object arg) {
        Truth.assertWithMessage((String)("Unable to format " + arg + " using " + this.getSubject())).that(Boolean.valueOf(((FormatType)this.getSubject()).canFormat(arg))).isTrue();
    }

    public void cannotFormat(Object arg) {
        Truth.assertWithMessage((String)("Expected error when formatting " + arg + " using " + this.getSubject())).that(Boolean.valueOf(((FormatType)this.getSubject()).canFormat(arg))).isFalse();
    }

    public void isNumeric() {
        Truth.assertWithMessage((String)("Expected " + this.getSubject() + " to be numeric but wasn't")).that(Boolean.valueOf(((FormatType)this.getSubject()).isNumeric())).isTrue();
    }

    public void isNotNumeric() {
        Truth.assertWithMessage((String)("Expected " + this.getSubject() + " to not be numeric but was")).that(Boolean.valueOf(((FormatType)this.getSubject()).isNumeric())).isFalse();
    }
}

