/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.testing;

import com.google.common.base.Preconditions;
import com.google.common.flogger.MetadataKey;
import com.google.common.flogger.backend.Metadata;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class MetadataSubject
extends Subject<MetadataSubject, Metadata> {
    private static final Subject.Factory<MetadataSubject, Metadata> METADATA_SUBJECT_FACTORY = MetadataSubject::new;

    public static Subject.Factory<MetadataSubject, Metadata> metadata() {
        return METADATA_SUBJECT_FACTORY;
    }

    public static MetadataSubject assertThat(@Nullable Metadata metadata) {
        return (MetadataSubject)Truth.assertAbout(MetadataSubject.metadata()).that((Object)metadata);
    }

    private MetadataSubject(FailureMetadata failureMetadata, @Nullable Metadata subject) {
        super(failureMetadata, (Object)subject);
    }

    private List<MetadataKey<?>> keyList() {
        Metadata metadata = (Metadata)this.actual();
        ArrayList keys = new ArrayList();
        for (int n = 0; n < metadata.size(); ++n) {
            keys.add(metadata.getKey(n));
        }
        return keys;
    }

    private List<Object> valueList() {
        Metadata metadata = (Metadata)this.actual();
        ArrayList<Object> values = new ArrayList<Object>();
        for (int n = 0; n < metadata.size(); ++n) {
            values.add(metadata.getValue(n));
        }
        return values;
    }

    public void hasSize(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (String)"expectedSize(%s) must be >= 0", (int)expectedSize);
        int actualSize = ((Metadata)this.actual()).size();
        if (actualSize != expectedSize) {
            this.failWithBadResults("has a size of", expectedSize, "is", actualSize);
        }
    }

    public <T> void containsUniqueEntry(MetadataKey<T> key, T value) {
        Preconditions.checkNotNull(key, (Object)"key must not be null");
        Preconditions.checkNotNull(value, (Object)"value must not be null");
        Object actual = ((Metadata)this.actual()).findValue(key);
        if (actual == null) {
            this.fail("contained value for key", key);
        } else if (!value.equals(actual)) {
            this.failWithBadResults("contained mapping '" + key + "':", value, "was", actual);
        } else {
            List<MetadataKey<?>> keys = this.keyList();
            if (keys.indexOf(key) != keys.lastIndexOf(key)) {
                this.fail("has unique key", key);
            }
        }
    }

    public IterableSubject keys() {
        return this.check().that(this.keyList());
    }

    public IterableSubject values() {
        return this.check().that(this.valueList());
    }
}

