/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.testing;

import com.google.common.flogger.AbstractLogger;
import com.google.common.flogger.LogContext;
import com.google.common.flogger.LogFormat;
import com.google.common.flogger.LoggingApi;
import com.google.common.flogger.backend.LoggerBackend;
import com.google.common.flogger.parser.DefaultBraceStyleMessageParser;
import com.google.common.flogger.parser.DefaultPrintfMessageParser;
import com.google.common.flogger.parser.MessageParser;
import com.google.common.flogger.util.Checks;
import java.util.logging.Level;

public final class TestLogger
extends AbstractLogger<Api> {
    private static final long DEFAULT_TIMESTAMP_NANOS = 946684800000000000L;
    private LogFormat format = LogFormat.PRINTF_STYLE;

    public static TestLogger create(LoggerBackend backend) {
        return new TestLogger(backend);
    }

    private TestLogger(LoggerBackend backend) {
        super(backend);
    }

    public final TestLogger setFormat(LogFormat format) {
        this.format = (LogFormat)Checks.checkNotNull((Object)format, (String)"format");
        return this;
    }

    public Api at(Level level) {
        return this.at(level, 946684800000000000L);
    }

    public Api at(Level level, long timestampNanos) {
        return new TestContext(level, false, timestampNanos);
    }

    public Api forceAt(Level level) {
        return this.forceAt(level, 946684800000000000L);
    }

    public Api forceAt(Level level, long timestampNanos) {
        return new TestContext(level, true, timestampNanos);
    }

    public static interface Api
    extends LoggingApi<Api> {
    }

    private final class TestContext
    extends LogContext<TestLogger, Api>
    implements Api {
        private TestContext(Level level, boolean isForced, long timestampMicros) {
            super(level, isForced, timestampMicros);
        }

        protected TestLogger getLogger() {
            return TestLogger.this;
        }

        protected Api api() {
            return this;
        }

        protected Api noOp() {
            throw new UnsupportedOperationException("There is no no-op implementation of the logging API for the testing logger.");
        }

        protected final MessageParser getMessageParser() {
            switch (TestLogger.this.format) {
                case PRINTF_STYLE: {
                    return DefaultPrintfMessageParser.getInstance();
                }
                case BRACE_STYLE: {
                    return DefaultBraceStyleMessageParser.getInstance();
                }
            }
            throw new AssertionError((Object)("unsupported format type: " + TestLogger.this.format));
        }
    }
}

